/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaMuxer;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaMuxer.class, minSdk=21)
public class ShadowMediaMuxer {
    private static final ConcurrentHashMap<Long, FileOutputStream> outputStreams = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, AtomicInteger> nextTrackIndices = new ConcurrentHashMap();
    private static final ConcurrentHashMap<FileDescriptor, FileOutputStream> fdToStream = new ConcurrentHashMap();
    private static final Random random = new Random();
    private static final int MUXER_STATE_INITIALIZED = 0;
    @RealObject
    private MediaMuxer realMuxer;

    @Implementation
    protected void __constructor__(String path, int format) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        FileOutputStream stream = new FileOutputStream(path);
        FileDescriptor fd = stream.getFD();
        fdToStream.put(fd, stream);
        CloseGuard guard = CloseGuard.get();
        ReflectionHelpers.setField(MediaMuxer.class, (Object)this.realMuxer, (String)"mCloseGuard", (Object)guard);
        ReflectionHelpers.setField(MediaMuxer.class, (Object)this.realMuxer, (String)"mLastTrackIndex", (Object)-1);
        if (RuntimeEnvironment.getApiLevel() < 26) {
            long nativeObject = ShadowMediaMuxer.nativeSetup(fd, format);
            ReflectionHelpers.setField(MediaMuxer.class, (Object)this.realMuxer, (String)"mNativeObject", (Object)nativeObject);
            ReflectionHelpers.setField(MediaMuxer.class, (Object)this.realMuxer, (String)"mState", (Object)0);
            guard.open("release");
        } else {
            ReflectionHelpers.callInstanceMethod(MediaMuxer.class, (Object)this.realMuxer, (String)"setUpMediaMuxer", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(FileDescriptor.class, (Object)fd), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)format)});
        }
    }

    @Implementation
    protected static long nativeSetup(FileDescriptor fd, int format) throws IOException {
        long potentialKey;
        FileOutputStream outputStream = fdToStream.get(fd);
        while ((potentialKey = random.nextLong()) == 0L || outputStreams.putIfAbsent(potentialKey, outputStream) != null) {
        }
        nextTrackIndices.put(potentialKey, new AtomicInteger(0));
        return potentialKey;
    }

    @Implementation
    protected static int nativeAddTrack(long nativeObject, String[] keys, Object[] values) {
        AtomicInteger nextTrackIndex = nextTrackIndices.get(nativeObject);
        if (nextTrackIndex == null) {
            throw new IllegalStateException("No next track index configured for key: " + nativeObject);
        }
        return nextTrackIndex.getAndIncrement();
    }

    @Implementation
    protected static void nativeWriteSampleData(long nativeObject, int trackIndex, ByteBuffer byteBuf, int offset, int size, long presentationTimeUs, int flags) {
        byte[] bytes = new byte[size];
        int oldPosition = byteBuf.position();
        byteBuf.position(offset);
        byteBuf.get(bytes, 0, size);
        byteBuf.position(oldPosition);
        try {
            ShadowMediaMuxer.getStream(nativeObject).write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to temporary file.", e);
        }
    }

    @Implementation
    protected static void nativeStop(long nativeObject) {
        try {
            ShadowMediaMuxer.getStream(nativeObject).close();
            fdToStream.remove(outputStreams.remove(nativeObject).getFD());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close temporary file.", e);
        }
    }

    private static FileOutputStream getStream(long streamKey) {
        FileOutputStream stream = outputStreams.get(streamKey);
        if (stream == null) {
            throw new IllegalStateException("No output stream configured for key: " + streamKey);
        }
        return stream;
    }
}

