/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.httpclient;

import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.robolectric.shadows.httpclient.FakeHttpLayer;
import org.robolectric.shadows.httpclient.HttpRequestInfo;
import org.robolectric.shadows.httpclient.HttpResponseGenerator;
import org.robolectric.shadows.httpclient.RequestMatcher;
import org.robolectric.shadows.httpclient.ShadowDefaultRequestDirector;

public class FakeHttp {
    private static FakeHttpLayer instance = new FakeHttpLayer();

    public static void addPendingHttpResponse(int statusCode, String responseBody, Header ... headers) {
        FakeHttp.getFakeHttpLayer().addPendingHttpResponse(statusCode, responseBody, headers);
    }

    @Deprecated
    public static void addPendingHttpResponseWithContentType(int statusCode, String responseBody, Header contentType) {
        FakeHttp.getFakeHttpLayer().addPendingHttpResponse(statusCode, responseBody, contentType);
    }

    public static void addPendingHttpResponse(HttpResponse httpResponse) {
        FakeHttp.getFakeHttpLayer().addPendingHttpResponse(httpResponse);
    }

    public static void addPendingHttpResponse(HttpResponseGenerator httpResponseGenerator) {
        FakeHttp.getFakeHttpLayer().addPendingHttpResponse(httpResponseGenerator);
    }

    public static HttpRequest getSentHttpRequest(int index) {
        return FakeHttp.getFakeHttpLayer().getSentHttpRequestInfo(index).getHttpRequest();
    }

    public static HttpRequest getLatestSentHttpRequest() {
        return ShadowDefaultRequestDirector.getLatestSentHttpRequest();
    }

    public static boolean httpRequestWasMade() {
        return FakeHttp.getFakeHttpLayer().hasRequestInfos();
    }

    public static boolean httpRequestWasMade(String uri) {
        return FakeHttp.getFakeHttpLayer().hasRequestMatchingRule(new FakeHttpLayer.UriRequestMatcher(uri));
    }

    public static HttpRequestInfo getSentHttpRequestInfo(int index) {
        return FakeHttp.getFakeHttpLayer().getSentHttpRequestInfo(index);
    }

    public static HttpRequest getNextSentHttpRequest() {
        HttpRequestInfo httpRequestInfo = FakeHttp.getFakeHttpLayer().getNextSentHttpRequestInfo();
        return httpRequestInfo == null ? null : httpRequestInfo.getHttpRequest();
    }

    public static HttpRequestInfo getNextSentHttpRequestInfo() {
        return FakeHttp.getFakeHttpLayer().getNextSentHttpRequestInfo();
    }

    public static void addHttpResponseRule(String method, String uri, HttpResponse response) {
        FakeHttp.getFakeHttpLayer().addHttpResponseRule(method, uri, response);
    }

    public static void addHttpResponseRule(String uri, HttpResponse response) {
        FakeHttp.getFakeHttpLayer().addHttpResponseRule(uri, response);
    }

    public static void addHttpResponseRule(String uri, String response) {
        FakeHttp.getFakeHttpLayer().addHttpResponseRule(uri, response);
    }

    public static void addHttpResponseRule(RequestMatcher requestMatcher, HttpResponse response) {
        FakeHttp.getFakeHttpLayer().addHttpResponseRule(requestMatcher, response);
    }

    public static void addHttpResponseRule(RequestMatcher requestMatcher, List<? extends HttpResponse> responses) {
        FakeHttp.getFakeHttpLayer().addHttpResponseRule(requestMatcher, responses);
    }

    public static FakeHttpLayer getFakeHttpLayer() {
        return instance;
    }

    public static void setDefaultHttpResponse(int statusCode, String responseBody) {
        FakeHttp.getFakeHttpLayer().setDefaultHttpResponse(statusCode, responseBody);
    }

    public static void setDefaultHttpResponse(HttpResponse defaultHttpResponse) {
        FakeHttp.getFakeHttpLayer().setDefaultHttpResponse(defaultHttpResponse);
    }

    public static void clearHttpResponseRules() {
        FakeHttp.getFakeHttpLayer().clearHttpResponseRules();
    }

    public static void clearPendingHttpResponses() {
        FakeHttp.getFakeHttpLayer().clearPendingHttpResponses();
    }

    public static void reset() {
        instance = new FakeHttpLayer();
    }
}

