/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.httpclient;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.robolectric.shadows.httpclient.HttpEntityStub;
import org.robolectric.shadows.httpclient.HttpRequestInfo;
import org.robolectric.shadows.httpclient.HttpResponseGenerator;
import org.robolectric.shadows.httpclient.ParamsParser;
import org.robolectric.shadows.httpclient.RequestMatcher;
import org.robolectric.shadows.httpclient.TestHttpResponse;

public class FakeHttpLayer {
    private final List<HttpResponseGenerator> pendingHttpResponses = new ArrayList<HttpResponseGenerator>();
    private final List<HttpRequestInfo> httpRequestInfos = new ArrayList<HttpRequestInfo>();
    private final List<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
    private final List<HttpEntityStub.ResponseRule> httpResponseRules = new ArrayList<HttpEntityStub.ResponseRule>();
    private HttpResponse defaultHttpResponse;
    private boolean interceptHttpRequests = true;
    private boolean logHttpRequests = false;
    private List<byte[]> httpResposeContent = new ArrayList<byte[]>();
    private boolean interceptResponseContent;

    public HttpRequestInfo getLastSentHttpRequestInfo() {
        List<HttpRequestInfo> requestInfos = this.getSentHttpRequestInfos();
        if (requestInfos.isEmpty()) {
            return null;
        }
        return requestInfos.get(requestInfos.size() - 1);
    }

    public void addPendingHttpResponse(int statusCode, String responseBody, Header ... headers) {
        this.addPendingHttpResponse(new TestHttpResponse(statusCode, responseBody, headers));
    }

    public void addPendingHttpResponse(final HttpResponse httpResponse) {
        this.addPendingHttpResponse(new HttpResponseGenerator(){

            @Override
            public HttpResponse getResponse(HttpRequest request) {
                return httpResponse;
            }
        });
    }

    public void addPendingHttpResponse(HttpResponseGenerator httpResponseGenerator) {
        this.pendingHttpResponses.add(httpResponseGenerator);
    }

    public void addHttpResponseRule(String method, String uri, HttpResponse response) {
        this.addHttpResponseRule((RequestMatcher)new DefaultRequestMatcher(method, uri), response);
    }

    public void addHttpResponseRule(String uri, HttpResponse response) {
        this.addHttpResponseRule((RequestMatcher)new UriRequestMatcher(uri), response);
    }

    public void addHttpResponseRule(String uri, String response) {
        this.addHttpResponseRule((RequestMatcher)new UriRequestMatcher(uri), (HttpResponse)new TestHttpResponse(200, response));
    }

    public void addHttpResponseRule(RequestMatcher requestMatcher, HttpResponse response) {
        this.addHttpResponseRule(new RequestMatcherResponseRule(requestMatcher, response));
    }

    public void addHttpResponseRule(RequestMatcher requestMatcher, List<? extends HttpResponse> responses) {
        this.addHttpResponseRule(new RequestMatcherResponseRule(requestMatcher, responses));
    }

    public void addHttpResponseRule(HttpEntityStub.ResponseRule responseRule) {
        this.httpResponseRules.add(0, responseRule);
    }

    public void setDefaultHttpResponse(HttpResponse defaultHttpResponse) {
        this.defaultHttpResponse = defaultHttpResponse;
    }

    public void setDefaultHttpResponse(int statusCode, String responseBody) {
        this.setDefaultHttpResponse(new TestHttpResponse(statusCode, responseBody));
    }

    private HttpResponse findResponse(HttpRequest httpRequest) throws HttpException, IOException {
        if (!this.pendingHttpResponses.isEmpty()) {
            return this.pendingHttpResponses.remove(0).getResponse(httpRequest);
        }
        for (HttpEntityStub.ResponseRule httpResponseRule : this.httpResponseRules) {
            if (!httpResponseRule.matches(httpRequest)) continue;
            return httpResponseRule.getResponse();
        }
        System.err.println("Unexpected HTTP call " + httpRequest.getRequestLine());
        return this.defaultHttpResponse;
    }

    public HttpResponse emulateRequest(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext, RequestDirector requestDirector) throws HttpException, IOException {
        if (this.logHttpRequests) {
            System.out.println("  <-- " + httpRequest.getRequestLine());
        }
        HttpResponse httpResponse = this.findResponse(httpRequest);
        if (this.logHttpRequests) {
            System.out.println("  --> " + (httpResponse == null ? null : Integer.valueOf(httpResponse.getStatusLine().getStatusCode())));
        }
        if (httpResponse == null) {
            throw new RuntimeException("Unexpected call to execute, no pending responses are available. See Robolectric.addPendingResponse(). Request was: " + httpRequest.getRequestLine().getMethod() + " " + httpRequest.getRequestLine().getUri());
        }
        HttpParams params = httpResponse.getParams();
        if (HttpConnectionParams.getConnectionTimeout((HttpParams)params) < 0) {
            throw new ConnectTimeoutException("Socket is not connected");
        }
        if (HttpConnectionParams.getSoTimeout((HttpParams)params) < 0) {
            throw new ConnectTimeoutException("The operation timed out");
        }
        this.addRequestInfo(new HttpRequestInfo(httpRequest, httpHost, httpContext, requestDirector));
        this.addHttpResponse(httpResponse);
        return httpResponse;
    }

    public boolean hasPendingResponses() {
        return !this.pendingHttpResponses.isEmpty();
    }

    public boolean hasRequestInfos() {
        return !this.httpRequestInfos.isEmpty();
    }

    public void clearRequestInfos() {
        this.httpRequestInfos.clear();
    }

    public void addRequestInfo(HttpRequestInfo requestInfo) {
        this.httpRequestInfos.add(requestInfo);
    }

    public boolean hasResponseRules() {
        return !this.httpResponseRules.isEmpty();
    }

    public boolean hasRequestMatchingRule(RequestMatcher rule) {
        for (HttpRequestInfo requestInfo : this.httpRequestInfos) {
            if (!rule.matches(requestInfo.httpRequest)) continue;
            return true;
        }
        return false;
    }

    public HttpRequestInfo getSentHttpRequestInfo(int index) {
        return this.httpRequestInfos.get(index);
    }

    public HttpRequestInfo getNextSentHttpRequestInfo() {
        return this.httpRequestInfos.size() > 0 ? this.httpRequestInfos.remove(0) : null;
    }

    public void logHttpRequests() {
        this.logHttpRequests = true;
    }

    public void silence() {
        this.logHttpRequests = false;
    }

    public List<HttpRequestInfo> getSentHttpRequestInfos() {
        return new ArrayList<HttpRequestInfo>(this.httpRequestInfos);
    }

    public void clearHttpResponseRules() {
        this.httpResponseRules.clear();
    }

    public void clearPendingHttpResponses() {
        this.pendingHttpResponses.clear();
    }

    public List<HttpResponse> getHttpResponses() {
        return new ArrayList<HttpResponse>(this.httpResponses);
    }

    public void addHttpResponse(HttpResponse response) {
        this.httpResponses.add(response);
    }

    public void addHttpResponseContent(byte[] content) {
        this.httpResposeContent.add(content);
    }

    public List<byte[]> getHttpResposeContentList() {
        return this.httpResposeContent;
    }

    public HttpResponse getLastHttpResponse() {
        if (this.httpResponses.isEmpty()) {
            return null;
        }
        return this.httpResponses.get(this.httpResponses.size() - 1);
    }

    public void clearHttpResponses() {
        this.httpResponses.clear();
    }

    public void interceptHttpRequests(boolean interceptHttpRequests) {
        this.interceptHttpRequests = interceptHttpRequests;
    }

    public boolean isInterceptingHttpRequests() {
        return this.interceptHttpRequests;
    }

    public void interceptResponseContent(boolean interceptResponseContent) {
        this.interceptResponseContent = interceptResponseContent;
    }

    public boolean isInterceptingResponseContent() {
        return this.interceptResponseContent;
    }

    public static class UriRegexMatcher
    implements RequestMatcher {
        private String method;
        private final Pattern uriRegex;

        public UriRegexMatcher(String method, String uriRegex) {
            this.method = method;
            this.uriRegex = Pattern.compile(uriRegex);
        }

        @Override
        public boolean matches(HttpRequest request) {
            return request.getRequestLine().getMethod().equals(this.method) && this.uriRegex.matcher(request.getRequestLine().getUri()).matches();
        }
    }

    public static class RequestMatcherBuilder
    implements RequestMatcher {
        private String method;
        private String hostname;
        private String path;
        private boolean noParams;
        private Map<String, String> params = new HashMap<String, String>();
        private Map<String, String> headers = new HashMap<String, String>();
        private PostBodyMatcher postBodyMatcher;

        public RequestMatcherBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RequestMatcherBuilder host(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public RequestMatcherBuilder path(String path) {
            if (path.startsWith("/")) {
                throw new RuntimeException("Path should not start with '/'");
            }
            this.path = "/" + path;
            return this;
        }

        public RequestMatcherBuilder param(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public RequestMatcherBuilder noParams() {
            this.noParams = true;
            return this;
        }

        public RequestMatcherBuilder postBody(PostBodyMatcher postBodyMatcher) {
            this.postBodyMatcher = postBodyMatcher;
            return this;
        }

        public RequestMatcherBuilder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        @Override
        public boolean matches(HttpRequest request) {
            Map<String, String> requestParams;
            URI uri = URI.create(request.getRequestLine().getUri());
            if (this.method != null && !this.method.equals(request.getRequestLine().getMethod())) {
                return false;
            }
            if (this.hostname != null && !this.hostname.equals(uri.getHost())) {
                return false;
            }
            if (this.path != null && !this.path.equals(uri.getRawPath())) {
                return false;
            }
            if (this.noParams && !uri.getRawQuery().equals(null)) {
                return false;
            }
            if (this.params.size() > 0 && !(requestParams = ParamsParser.parseParams(request)).equals(this.params)) {
                return false;
            }
            if (this.headers.size() > 0) {
                HashMap<String, String> actualRequestHeaders = new HashMap<String, String>();
                for (Header header : request.getAllHeaders()) {
                    actualRequestHeaders.put(header.getName(), header.getValue());
                }
                if (!this.headers.equals(actualRequestHeaders)) {
                    return false;
                }
            }
            if (this.postBodyMatcher != null) {
                if (!(request instanceof HttpEntityEnclosingRequestBase)) {
                    return false;
                }
                HttpEntityEnclosingRequestBase postOrPut = (HttpEntityEnclosingRequestBase)request;
                try {
                    if (!this.postBodyMatcher.matches(postOrPut.getEntity())) {
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getPath() {
            return this.path;
        }

        public String getParam(String key) {
            return this.params.get(key);
        }

        public String getHeader(String key) {
            return this.headers.get(key);
        }

        public boolean isNoParams() {
            return this.noParams;
        }

        public String getMethod() {
            return this.method;
        }

        public static interface PostBodyMatcher {
            public boolean matches(HttpEntity var1) throws IOException;
        }
    }

    public static class UriRequestMatcher
    implements RequestMatcher {
        private String uri;

        public UriRequestMatcher(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean matches(HttpRequest request) {
            return request.getRequestLine().getUri().equals(this.uri);
        }
    }

    public static class DefaultRequestMatcher
    implements RequestMatcher {
        private String method;
        private String uri;

        public DefaultRequestMatcher(String method, String uri) {
            this.method = method;
            this.uri = uri;
        }

        @Override
        public boolean matches(HttpRequest request) {
            return request.getRequestLine().getMethod().equals(this.method) && request.getRequestLine().getUri().equals(this.uri);
        }
    }

    public static class RequestMatcherResponseRule
    implements HttpEntityStub.ResponseRule {
        private RequestMatcher requestMatcher;
        private HttpResponse responseToGive;
        private IOException ioException;
        private HttpException httpException;
        private List<? extends HttpResponse> responses;

        public RequestMatcherResponseRule(RequestMatcher requestMatcher, HttpResponse responseToGive) {
            this.requestMatcher = requestMatcher;
            this.responseToGive = responseToGive;
        }

        public RequestMatcherResponseRule(RequestMatcher requestMatcher, IOException ioException) {
            this.requestMatcher = requestMatcher;
            this.ioException = ioException;
        }

        public RequestMatcherResponseRule(RequestMatcher requestMatcher, HttpException httpException) {
            this.requestMatcher = requestMatcher;
            this.httpException = httpException;
        }

        public RequestMatcherResponseRule(RequestMatcher requestMatcher, List<? extends HttpResponse> responses) {
            this.requestMatcher = requestMatcher;
            this.responses = responses;
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.requestMatcher.matches(request);
        }

        @Override
        public HttpResponse getResponse() throws HttpException, IOException {
            if (this.httpException != null) {
                throw this.httpException;
            }
            if (this.ioException != null) {
                throw this.ioException;
            }
            if (this.responseToGive != null) {
                return this.responseToGive;
            }
            if (this.responses.isEmpty()) {
                throw new RuntimeException("No more responses left to give");
            }
            return this.responses.remove(0);
        }
    }
}

