/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.robolectric.shadows.httpclient.HttpEntityStub;
import org.robolectric.shadows.httpclient.HttpResponseStub;
import org.robolectric.shadows.httpclient.StatusLineStub;

public class TestHttpResponse
extends HttpResponseStub {
    private int statusCode;
    private byte[] responseBody;
    private TestStatusLine statusLine = new TestStatusLine();
    private TestHttpEntity httpEntity = new TestHttpEntity();
    private int openEntityContentStreamCount = 0;
    private Header[] headers = new Header[0];
    private HttpParams params = new BasicHttpParams();

    public TestHttpResponse() {
        this.statusCode = 200;
        this.responseBody = new byte[0];
    }

    public TestHttpResponse(int statusCode, String responseBody) {
        this.statusCode = statusCode;
        this.responseBody = responseBody.getBytes(StandardCharsets.UTF_8);
    }

    public TestHttpResponse(int statusCode, String responseBody, Header ... headers) {
        this(statusCode, responseBody.getBytes(StandardCharsets.UTF_8), headers);
    }

    public TestHttpResponse(int statusCode, byte[] responseBody, Header ... headers) {
        this.statusCode = statusCode;
        this.responseBody = (byte[])responseBody.clone();
        this.headers = headers;
    }

    protected void setResponseBody(String responseBody) {
        this.responseBody = responseBody.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    @Override
    public HttpEntity getEntity() {
        return this.httpEntity;
    }

    @Override
    public Header[] getAllHeaders() {
        return this.headers;
    }

    @Override
    public Header getFirstHeader(String s) {
        for (Header h : this.headers) {
            if (!s.equalsIgnoreCase(h.getName())) continue;
            return h;
        }
        return null;
    }

    @Override
    public Header getLastHeader(String s) {
        for (int i = this.headers.length - 1; i >= 0; --i) {
            if (!this.headers[i].getName().equalsIgnoreCase(s)) continue;
            return this.headers[i];
        }
        return null;
    }

    @Override
    public Header[] getHeaders(String s) {
        ArrayList<Header> found = new ArrayList<Header>();
        for (Header h : this.headers) {
            if (!h.getName().equalsIgnoreCase(s)) continue;
            found.add(h);
        }
        return found.toArray(new Header[found.size()]);
    }

    @Override
    public void addHeader(Header header) {
        ArrayList<Header> temp = new ArrayList<Header>();
        Collections.addAll(temp, this.headers);
        temp.add(header);
        this.headers = temp.toArray(new Header[temp.size()]);
    }

    @Override
    public void setHeader(Header newHeader) {
        for (int i = 0; i < this.headers.length; ++i) {
            Header header = this.headers[i];
            if (!header.getName().equals(newHeader.getName())) continue;
            this.headers[i] = newHeader;
            return;
        }
    }

    @Override
    public HeaderIterator headerIterator() {
        return new HeaderIterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < TestHttpResponse.this.headers.length;
            }

            public Header nextHeader() {
                if (this.index >= TestHttpResponse.this.headers.length) {
                    throw new NoSuchElementException();
                }
                return TestHttpResponse.this.headers[this.index++];
            }

            public Object next() {
                return this.nextHeader();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public HeaderIterator headerIterator(final String s) {
        return new HeaderIterator(){
            int index = 0;

            public boolean hasNext() {
                return this.nextIndex() != -1;
            }

            private int nextIndex() {
                for (int i = this.index; i < TestHttpResponse.this.headers.length; ++i) {
                    if (!TestHttpResponse.this.headers[i].getName().equalsIgnoreCase(s)) continue;
                    return i;
                }
                return -1;
            }

            public Header nextHeader() {
                this.index = this.nextIndex();
                if (this.index == -1) {
                    throw new NoSuchElementException();
                }
                return TestHttpResponse.this.headers[this.index++];
            }

            public Object next() {
                return this.nextHeader();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean containsHeader(String s) {
        return this.getFirstHeader(s) != null;
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void setParams(HttpParams httpParams) {
        this.params = httpParams;
    }

    public boolean entityContentStreamsHaveBeenClosed() {
        return this.openEntityContentStreamCount == 0;
    }

    public class TestStatusLine
    extends StatusLineStub {
        @Override
        public ProtocolVersion getProtocolVersion() {
            return new HttpVersion(1, 0);
        }

        @Override
        public int getStatusCode() {
            return TestHttpResponse.this.statusCode;
        }

        @Override
        public String getReasonPhrase() {
            return "HTTP status " + TestHttpResponse.this.statusCode;
        }

        public String toString() {
            return "TestStatusLine[" + this.getReasonPhrase() + "]";
        }
    }

    public class TestHttpEntity
    extends HttpEntityStub {
        private ByteArrayInputStream inputStream;

        @Override
        public long getContentLength() {
            return TestHttpResponse.this.responseBody.length;
        }

        @Override
        public Header getContentType() {
            return TestHttpResponse.this.getFirstHeader("Content-Type");
        }

        @Override
        public Header getContentEncoding() {
            return TestHttpResponse.this.getFirstHeader("Content-Encoding");
        }

        @Override
        public boolean isStreaming() {
            return true;
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            TestHttpResponse.this.openEntityContentStreamCount++;
            this.inputStream = new ByteArrayInputStream(TestHttpResponse.this.responseBody){

                @Override
                public void close() throws IOException {
                    TestHttpResponse.this.openEntityContentStreamCount--;
                    super.close();
                }
            };
            return this.inputStream;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(TestHttpResponse.this.responseBody);
        }

        @Override
        public void consumeContent() throws IOException {
        }
    }
}

