/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.support.v4;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.robolectric.Robolectric;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.Provider;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=LocalBroadcastManager.class)
public class ShadowLocalBroadcastManager {
    private final List<Intent> sentBroadcastIntents = new ArrayList<Intent>();
    private final List<Wrapper> registeredReceivers = new ArrayList<Wrapper>();

    @Implementation
    public static LocalBroadcastManager getInstance(final Context context) {
        return (LocalBroadcastManager)ShadowApplication.getInstance().getSingleton(LocalBroadcastManager.class, (Provider)new Provider<LocalBroadcastManager>(){

            public LocalBroadcastManager get() {
                return (LocalBroadcastManager)ReflectionHelpers.callConstructor(LocalBroadcastManager.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
            }
        });
    }

    @Implementation
    public void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.registeredReceivers.add(new Wrapper(receiver, filter));
    }

    @Implementation
    public void unregisterReceiver(BroadcastReceiver receiver) {
        Iterator<Wrapper> iterator = this.registeredReceivers.iterator();
        while (iterator.hasNext()) {
            Wrapper wrapper = iterator.next();
            if (wrapper.broadcastReceiver != receiver) continue;
            iterator.remove();
        }
    }

    @Implementation
    public boolean sendBroadcast(Intent intent) {
        boolean sent = false;
        this.sentBroadcastIntents.add(intent);
        ArrayList<Wrapper> copy = new ArrayList<Wrapper>();
        copy.addAll(this.registeredReceivers);
        for (Wrapper wrapper : copy) {
            int match;
            if (!wrapper.intentFilter.matchAction(intent.getAction()) || (match = wrapper.intentFilter.matchData(intent.getType(), intent.getScheme(), intent.getData())) == -2 || match == -1) continue;
            sent = true;
            final BroadcastReceiver receiver = wrapper.broadcastReceiver;
            final Intent broadcastIntent = intent;
            Robolectric.getForegroundThreadScheduler().post(new Runnable(){

                @Override
                public void run() {
                    receiver.onReceive((Context)RuntimeEnvironment.application, broadcastIntent);
                }
            });
        }
        return sent;
    }

    public List<Intent> getSentBroadcastIntents() {
        return this.sentBroadcastIntents;
    }

    public List<Wrapper> getRegisteredBroadcastReceivers() {
        return this.registeredReceivers;
    }

    public static class Wrapper {
        public final BroadcastReceiver broadcastReceiver;
        public final IntentFilter intentFilter;

        public Wrapper(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
            this.broadcastReceiver = broadcastReceiver;
            this.intentFilter = intentFilter;
        }
    }
}

