/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.support.v4;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.LinearLayout;
import org.robolectric.Robolectric;
import org.robolectric.ShadowsAdapter;
import org.robolectric.util.ActivityController;
import org.robolectric.util.ComponentController;

public class SupportFragmentController<F extends Fragment>
extends ComponentController<SupportFragmentController<F>, F> {
    private final F fragment;
    private final ActivityController<? extends FragmentActivity> activityController;

    protected SupportFragmentController(ShadowsAdapter shadowsAdapter, F fragment, Class<? extends FragmentActivity> activityClass) {
        super(shadowsAdapter, fragment);
        this.fragment = fragment;
        this.activityController = Robolectric.buildActivity(activityClass);
    }

    public static <F extends Fragment> SupportFragmentController<F> of(F fragment) {
        return new SupportFragmentController<F>(Robolectric.getShadowsAdapter(), fragment, FragmentControllerActivity.class);
    }

    public static <F extends Fragment> SupportFragmentController<F> of(F fragment, Class<? extends FragmentActivity> activityClass) {
        return new SupportFragmentController<F>(Robolectric.getShadowsAdapter(), fragment, activityClass);
    }

    public SupportFragmentController<F> attach() {
        return this;
    }

    public SupportFragmentController<F> create(final int contentViewId, final Bundle bundle) {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ((FragmentActivity)SupportFragmentController.this.activityController.create(bundle).get()).getSupportFragmentManager().beginTransaction().add(contentViewId, SupportFragmentController.this.fragment).commit();
            }
        });
        return this;
    }

    public SupportFragmentController<F> create(Bundle bundle) {
        return this.create(1, bundle);
    }

    public SupportFragmentController<F> create() {
        return this.create(null);
    }

    public SupportFragmentController<F> destroy() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.destroy();
            }
        });
        return this;
    }

    public SupportFragmentController<F> start() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.start();
            }
        });
        return this;
    }

    public SupportFragmentController<F> resume() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.resume();
            }
        });
        return this;
    }

    public SupportFragmentController<F> pause() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.pause();
            }
        });
        return this;
    }

    public SupportFragmentController<F> stop() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.stop();
            }
        });
        return this;
    }

    public SupportFragmentController<F> visible() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.visible();
            }
        });
        return this;
    }

    public SupportFragmentController<F> withIntent(final Intent intent) {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.withIntent(intent);
            }
        });
        return this;
    }

    private static class FragmentControllerActivity
    extends FragmentActivity {
        private FragmentControllerActivity() {
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            LinearLayout view = new LinearLayout((Context)this);
            view.setId(1);
            this.setContentView((View)view);
        }
    }
}

