/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.support.v4;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.robolectric.Robolectric;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=AsyncTaskLoader.class)
public class ShadowAsyncTaskLoader<D> {
    @RealObject
    private AsyncTaskLoader<D> realLoader;
    private BackgroundWorker worker;

    @Implementation
    public void __constructor__(Context context) {
        this.worker = new BackgroundWorker();
    }

    @Implementation
    public void onForceLoad() {
        FutureTask future = new FutureTask<D>(this.worker){

            @Override
            protected void done() {
                try {
                    final Object result = this.get();
                    Robolectric.getForegroundThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowAsyncTaskLoader.this.realLoader.deliverResult(result);
                        }
                    });
                }
                catch (InterruptedException result) {
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        };
        Robolectric.getBackgroundThreadScheduler().post((Runnable)future);
    }

    private final class BackgroundWorker
    implements Callable<D> {
        private BackgroundWorker() {
        }

        @Override
        public D call() throws Exception {
            return ShadowAsyncTaskLoader.this.realLoader.loadInBackground();
        }
    }
}

