/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.support.v4;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.LinearLayout;
import org.robolectric.Robolectric;
import org.robolectric.android.controller.ActivityController;
import org.robolectric.android.controller.ComponentController;

public class SupportFragmentController<F extends Fragment>
extends ComponentController<SupportFragmentController<F>, F> {
    private final F fragment;
    private final ActivityController<? extends FragmentActivity> activityController;

    protected SupportFragmentController(F fragment, Class<? extends FragmentActivity> activityClass) {
        this(fragment, activityClass, null);
    }

    protected SupportFragmentController(F fragment, Class<? extends FragmentActivity> activityClass, Intent intent) {
        super(fragment, intent);
        this.fragment = fragment;
        this.activityController = Robolectric.buildActivity(activityClass, (Intent)intent);
    }

    public static <F extends Fragment> SupportFragmentController<F> of(F fragment) {
        return new SupportFragmentController<F>(fragment, FragmentControllerActivity.class);
    }

    public static <F extends Fragment> SupportFragmentController<F> of(F fragment, Class<? extends FragmentActivity> activityClass) {
        return new SupportFragmentController<F>(fragment, activityClass);
    }

    public static <F extends Fragment> SupportFragmentController<F> of(F fragment, Class<? extends FragmentActivity> activityClass, Intent intent) {
        return new SupportFragmentController<F>(fragment, activityClass, intent);
    }

    public SupportFragmentController<F> create(final int contentViewId, final Bundle bundle) {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ((FragmentActivity)SupportFragmentController.this.activityController.create(bundle).get()).getSupportFragmentManager().beginTransaction().add(contentViewId, SupportFragmentController.this.fragment).commit();
            }
        });
        return this;
    }

    public SupportFragmentController<F> create(Bundle bundle) {
        return this.create(1, bundle);
    }

    public SupportFragmentController<F> create() {
        return this.create(null);
    }

    public SupportFragmentController<F> destroy() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.destroy();
            }
        });
        return this;
    }

    public SupportFragmentController<F> start() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.start();
            }
        });
        return this;
    }

    public SupportFragmentController<F> resume() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.resume();
            }
        });
        return this;
    }

    public SupportFragmentController<F> pause() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.pause();
            }
        });
        return this;
    }

    public SupportFragmentController<F> stop() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.stop();
            }
        });
        return this;
    }

    public SupportFragmentController<F> visible() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                SupportFragmentController.this.activityController.visible();
            }
        });
        return this;
    }

    private static class FragmentControllerActivity
    extends FragmentActivity {
        private FragmentControllerActivity() {
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            LinearLayout view = new LinearLayout((Context)this);
            view.setId(1);
            this.setContentView((View)view);
        }
    }
}

