/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.reflector;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class UnsafeAccess {
    private static final Danger DANGER = UnsafeAccess.getJavaVersion() < 11 ? new DangerPre11() : new Danger11Plus();

    static <T> Class<?> defineClass(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
        return DANGER.defineClass(iClass, reflectorClassName, bytecode);
    }

    public static void throwException(Throwable t) {
        DANGER.throwException(t);
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        assert (version != null);
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
    }

    private static class Danger11Plus
    implements Danger {
        private final Method privateLookupInMethod;
        private final Method defineClassMethod;

        private Danger11Plus() {
            try {
                this.privateLookupInMethod = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                this.defineClassMethod = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public <T> Class<?> defineClass(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                MethodHandles.Lookup privateLookup = (MethodHandles.Lookup)this.privateLookupInMethod.invoke((Object)lookup, iClass, lookup);
                return (Class)this.defineClassMethod.invoke((Object)privateLookup, new Object[]{bytecode});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void throwException(Throwable t) {
            throw new RuntimeException("huh? java 11, need help!", t);
        }
    }

    private static class DangerPre11
    implements Danger {
        private final Unsafe unsafe;

        private DangerPre11() {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                this.unsafe = (Unsafe)unsafeField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public <T> Class<?> defineClass(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
            return this.unsafe.defineClass(reflectorClassName, bytecode, 0, bytecode.length, iClass.getClassLoader(), null);
        }

        @Override
        public void throwException(Throwable t) {
            this.unsafe.throwException(t);
        }
    }

    static interface Danger {
        public <T> Class<?> defineClass(Class<T> var1, String var2, byte[] var3);

        public void throwException(Throwable var1);
    }
}

