/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;

public class Scheduler {
    private static final long START_TIME = 100L;
    private volatile long currentTime = 100L;
    private long nextTimeDisambiguator = 0L;
    private boolean isExecutingRunnable = false;
    private final Thread associatedThread = Thread.currentThread();
    private final PriorityQueue<ScheduledRunnable> runnables = new PriorityQueue();
    private volatile IdleState idleState = IdleState.UNPAUSED;

    public IdleState getIdleState() {
        return this.idleState;
    }

    public synchronized void setIdleState(IdleState idleState) {
        this.idleState = idleState;
        switch (idleState) {
            case UNPAUSED: {
                this.advanceBy(0L);
                break;
            }
            case CONSTANT_IDLE: {
                this.advanceToLastPostedRunnable();
                break;
            }
        }
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public synchronized void pause() {
        this.setIdleState(IdleState.PAUSED);
    }

    public synchronized void unPause() {
        this.setIdleState(IdleState.UNPAUSED);
    }

    public boolean isPaused() {
        return this.idleState == IdleState.PAUSED;
    }

    public synchronized void post(Runnable runnable) {
        this.postDelayed(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public synchronized void postDelayed(Runnable runnable, long delayMillis) {
        this.postDelayed(runnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized void postDelayed(Runnable runnable, long delay, TimeUnit unit) {
        long delayMillis = unit.toMillis(delay);
        if (this.idleState != IdleState.CONSTANT_IDLE && (this.isPaused() || delayMillis > 0L) || Thread.currentThread() != this.associatedThread) {
            this.runnables.add(new ScheduledRunnable(runnable, this.currentTime + delayMillis));
        } else {
            this.runOrQueueRunnable(runnable, this.currentTime + delayMillis);
        }
    }

    public synchronized void postAtFrontOfQueue(Runnable runnable) {
        if (this.isPaused() || Thread.currentThread() != this.associatedThread) {
            long timeDisambiguator = this.runnables.isEmpty() ? this.nextTimeDisambiguator++ : this.runnables.peek().timeDisambiguator - 1L;
            this.runnables.add(new ScheduledRunnable(runnable, 0L, timeDisambiguator));
        } else {
            this.runOrQueueRunnable(runnable, this.currentTime);
        }
    }

    public synchronized void remove(Runnable runnable) {
        Iterator<ScheduledRunnable> iterator = this.runnables.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().runnable != runnable) continue;
            iterator.remove();
        }
    }

    public synchronized boolean advanceToLastPostedRunnable() {
        long currentMaxTime = this.currentTime;
        for (ScheduledRunnable scheduled : this.runnables) {
            if (currentMaxTime >= scheduled.scheduledTime) continue;
            currentMaxTime = scheduled.scheduledTime;
        }
        return this.advanceTo(currentMaxTime);
    }

    public synchronized boolean advanceToNextPostedRunnable() {
        return !this.runnables.isEmpty() && this.advanceTo(this.runnables.peek().scheduledTime);
    }

    @Deprecated
    public synchronized boolean advanceBy(long interval) {
        return this.advanceBy(interval, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean advanceBy(long amount, TimeUnit unit) {
        long endingTime = this.currentTime + unit.toMillis(amount);
        return this.advanceTo(endingTime);
    }

    public synchronized boolean advanceTo(long endTime) {
        if (endTime < this.currentTime || this.runnables.isEmpty()) {
            this.currentTime = endTime;
            return false;
        }
        int runCount = 0;
        while (this.nextTaskIsScheduledBefore(endTime)) {
            this.runOneTask();
            ++runCount;
        }
        this.currentTime = endTime;
        return runCount > 0;
    }

    public synchronized boolean runOneTask() {
        ScheduledRunnable postedRunnable = this.runnables.poll();
        if (postedRunnable != null) {
            if (postedRunnable.scheduledTime > this.currentTime) {
                this.currentTime = postedRunnable.scheduledTime;
            }
            postedRunnable.run();
            return true;
        }
        return false;
    }

    public synchronized boolean areAnyRunnable() {
        return this.nextTaskIsScheduledBefore(this.currentTime);
    }

    public synchronized void reset() {
        this.runnables.clear();
        this.idleState = IdleState.UNPAUSED;
        this.currentTime = 100L;
        this.isExecutingRunnable = false;
    }

    public synchronized int size() {
        return this.runnables.size();
    }

    @Deprecated
    public void idleConstantly(boolean shouldIdleConstantly) {
        this.setIdleState(shouldIdleConstantly ? IdleState.CONSTANT_IDLE : IdleState.UNPAUSED);
    }

    private boolean nextTaskIsScheduledBefore(long endingTime) {
        return !this.runnables.isEmpty() && this.runnables.peek().scheduledTime <= endingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOrQueueRunnable(Runnable runnable, long scheduledTime) {
        if (this.isExecutingRunnable) {
            this.runnables.add(new ScheduledRunnable(runnable, scheduledTime));
            return;
        }
        this.isExecutingRunnable = true;
        try {
            runnable.run();
        }
        finally {
            this.isExecutingRunnable = false;
        }
        if (scheduledTime > this.currentTime) {
            this.currentTime = scheduledTime;
        }
        switch (this.idleState) {
            case CONSTANT_IDLE: {
                this.advanceToLastPostedRunnable();
                break;
            }
            case UNPAUSED: {
                this.advanceBy(0L);
                break;
            }
        }
    }

    private class ScheduledRunnable
    implements Comparable<ScheduledRunnable> {
        private final Runnable runnable;
        private final long scheduledTime;
        private final long timeDisambiguator;

        private ScheduledRunnable(Runnable runnable, long scheduledTime) {
            this(runnable, scheduledTime, scheduler.nextTimeDisambiguator++);
        }

        private ScheduledRunnable(Runnable runnable, long scheduledTime, long timeDisambiguator) {
            this.runnable = runnable;
            this.scheduledTime = scheduledTime;
            this.timeDisambiguator = timeDisambiguator;
        }

        @Override
        public int compareTo(ScheduledRunnable runnable) {
            int timeCompare = Long.compare(this.scheduledTime, runnable.scheduledTime);
            if (timeCompare == 0) {
                return Long.compare(this.timeDisambiguator, runnable.timeDisambiguator);
            }
            return timeCompare;
        }

        public void run() {
            Scheduler.this.isExecutingRunnable = true;
            try {
                this.runnable.run();
            }
            finally {
                Scheduler.this.isExecutingRunnable = false;
            }
        }
    }

    public static enum IdleState {
        PAUSED,
        UNPAUSED,
        CONSTANT_IDLE;

    }
}

