/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import org.robolectric.util.inject.InjectionException;
import org.robolectric.util.inject.ServiceFinder;
import org.robolectric.util.inject.Supercedes;

class PluginFinder {
    private final ServiceFinderAdapter serviceFinderAdapter;

    public PluginFinder() {
        this(new ServiceFinderAdapter());
    }

    PluginFinder(ServiceFinderAdapter serviceFinderAdapter) {
        this.serviceFinderAdapter = serviceFinderAdapter;
    }

    @Nullable
    <T> Class<? extends T> findPlugin(Class<T> pluginType) {
        return this.best(pluginType, this.findPlugins(pluginType));
    }

    @Nullable
    <T> Class<? extends T> findPlugin(Class<T> pluginType, ClassLoader classLoader) {
        return this.best(pluginType, this.findPlugins(pluginType, classLoader));
    }

    @Nonnull
    <T> List<Class<? extends T>> findPlugins(Class<T> pluginType) {
        return this.prioritize(this.filter(this.serviceFinderAdapter.load(pluginType)));
    }

    private <T> Iterable<Class<? extends T>> filter(Iterable<Class<? extends T>> classes) {
        HashSet superceded = new HashSet();
        for (Class<T> clazz : classes) {
            Supercedes supercedes = clazz.getAnnotation(Supercedes.class);
            if (supercedes == null) continue;
            superceded.add(supercedes.value());
        }
        if (superceded.isEmpty()) {
            return classes;
        }
        return () -> new Filterator<Class>(classes.iterator(), o -> !superceded.contains(o));
    }

    @Nonnull
    <T> List<Class<? extends T>> findPlugins(Class<T> pluginType, ClassLoader classLoader) {
        return this.prioritize(this.serviceFinderAdapter.load(pluginType, classLoader));
    }

    @Nullable
    private <T> Class<? extends T> best(Class<T> pluginType, List<Class<? extends T>> serviceClasses) {
        if (serviceClasses.isEmpty()) {
            return null;
        }
        Class<? extends T> first = serviceClasses.get(0);
        if (serviceClasses.size() == 1) {
            return first;
        }
        int topPriority = PluginFinder.priority(first);
        if ((serviceClasses = serviceClasses.stream().filter((? super T it) -> PluginFinder.priority(it) == topPriority).collect(Collectors.toList())).size() == 1) {
            return serviceClasses.get(0);
        }
        throw new InjectionException(pluginType, "too many implementations: " + serviceClasses);
    }

    @Nonnull
    private <T> List<Class<? extends T>> prioritize(Iterable<Class<? extends T>> iterable) {
        ArrayList<Class<T>> serviceClasses = new ArrayList<Class<T>>();
        for (Class<T> clazz : iterable) {
            serviceClasses.add(clazz);
        }
        Comparator<Class> c = Collections.reverseOrder(Comparator.comparing(PluginFinder::priority));
        c = c.thenComparing(Class::getName);
        serviceClasses.sort(c);
        return serviceClasses;
    }

    private static <T> int priority(Class<? extends T> pluginClass) {
        Priority priority = pluginClass.getAnnotation(Priority.class);
        return priority == null ? 0 : priority.value();
    }

    private static class Filterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;
        private final Predicate<T> predicate;
        private T next;

        public Filterator(Iterator<T> delegate, Predicate<T> predicate) {
            this.delegate = delegate;
            this.predicate = predicate;
            this.findNext();
        }

        void findNext() {
            while (this.delegate.hasNext()) {
                this.next = this.delegate.next();
                if (!this.predicate.test(this.next)) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            try {
                T t = this.next;
                return t;
            }
            finally {
                this.findNext();
            }
        }
    }

    static class ServiceFinderAdapter {
        ServiceFinderAdapter() {
        }

        @Nonnull
        <T> Iterable<Class<? extends T>> load(Class<T> pluginType) {
            return ServiceFinder.load(pluginType);
        }

        @Nonnull
        <T> Iterable<Class<? extends T>> load(Class<T> pluginType, ClassLoader classLoader) {
            return ServiceFinder.load(pluginType, classLoader);
        }
    }
}

