/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.inject;

import com.google.common.annotations.VisibleForTesting;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.robolectric.util.inject.AutoFactory;
import org.robolectric.util.inject.InjectionException;
import org.robolectric.util.inject.PluginFinder;
import org.robolectric.util.reflector.UnsafeAccess;

public class Injector {
    private static final Key<Object> INJECTOR_KEY = new Key((Type)((Object)Injector.class));
    private final Injector superInjector;
    private final PluginFinder pluginFinder;
    @GuardedBy(value="this")
    private final Map<Key<?>, Provider<?>> providers;
    private final Map<Key<?>, Class<?>> defaultImpls;

    public Injector() {
        this(new PluginFinder());
    }

    @VisibleForTesting
    Injector(PluginFinder pluginFinder) {
        this(null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), pluginFinder);
    }

    private Injector(Injector superInjector, Map<Key<?>, Provider<?>> providers, Map<Key<?>, Class<?>> explicitImpls, Map<Key<?>, Class<?>> defaultImpls, PluginFinder pluginFinder) {
        this.superInjector = superInjector;
        this.providers = new HashMap(providers);
        for (Map.Entry<Key<?>, Class<?>> e : explicitImpls.entrySet()) {
            this.providers.put(e.getKey(), this.memoized(() -> this.inject((Class)e.getValue())));
        }
        this.defaultImpls = new HashMap(defaultImpls);
        this.pluginFinder = pluginFinder;
    }

    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> type) {
        return this.getInstance(new Key((Type)type));
    }

    @Nonnull
    private <T> T getInstance(@Nonnull Key<T> key) {
        try {
            return this.getInstanceInternal(key);
        }
        catch (UnsatisfiedDependencyException e) {
            throw e.asInjectionException(key);
        }
    }

    private <T> T getInstanceInternal(@Nonnull Key<T> key) {
        if (this.superInjector != null) {
            try {
                return this.superInjector.getInstanceInternal(key);
            }
            catch (InjectionException | UnsatisfiedDependencyException runtimeException) {
                // empty catch block
            }
        }
        return (T)this.getProvider(key).get();
    }

    public Builder newScopeBuilder(ClassLoader classLoader) {
        return new Builder(this, classLoader);
    }

    @Nonnull
    private <T> Provider<T> memoized(@Nonnull Class<? extends T> implementingClass) {
        return this.memoized(() -> this.inject(implementingClass));
    }

    @Nonnull
    private <T> Provider<T> memoized(@Nonnull Provider<T> tProvider) {
        return new MemoizingProvider(tProvider);
    }

    @Nonnull
    private <T> T inject(@Nonnull Class<? extends T> implementingClass) {
        Constructor<T> ctor;
        try {
            ctor = this.findConstructor(implementingClass);
        }
        catch (IllegalArgumentException e) {
            throw new InjectionException(implementingClass, (Throwable)e);
        }
        Object[] params = this.resolveDependencies(ctor);
        try {
            return ctor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            UnsafeAccess.throwException((Throwable)e.getCause());
            throw new IllegalStateException();
        }
    }

    private <T> Constructor<T> findConstructor(@Nonnull Class<? extends T> implementingClass) {
        ArrayList injectCtors = new ArrayList();
        ArrayList otherCtors = new ArrayList();
        for (Constructor<?> ctor : implementingClass.getConstructors()) {
            if (ctor.isAnnotationPresent(Inject.class)) {
                injectCtors.add(ctor);
                continue;
            }
            otherCtors.add(ctor);
        }
        if (injectCtors.size() > 1) {
            throw new InjectionException(implementingClass, "multiple public @Inject constructors");
        }
        if (injectCtors.size() == 1) {
            return (Constructor)injectCtors.get(0);
        }
        if (otherCtors.size() > 1) {
            throw new InjectionException(implementingClass, "multiple public constructors");
        }
        if (otherCtors.size() == 1) {
            return (Constructor)otherCtors.get(0);
        }
        throw new InjectionException(implementingClass, "no public constructor");
    }

    private Object[] resolveDependencies(Executable ctor) {
        Object[] params = new Object[ctor.getParameterCount()];
        AnnotatedType[] paramTypes = ctor.getAnnotatedParameterTypes();
        Annotation[][] parameterAnnotations = ctor.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            AnnotatedType paramType = paramTypes[i];
            String name = this.findName(parameterAnnotations[i]);
            Key key = new Key(paramType.getType(), name);
            if (key.equals(INJECTOR_KEY)) {
                params[i] = this;
                continue;
            }
            try {
                params[i] = this.getInstanceInternal(key);
                continue;
            }
            catch (UnsatisfiedDependencyException e) {
                throw new UnsatisfiedDependencyException(new Key((Type)ctor.getDeclaringClass()), e);
            }
        }
        return params;
    }

    private String findName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Named)) continue;
            return ((Named)annotation).value();
        }
        return null;
    }

    @Nonnull
    private synchronized <T> Provider<T> getProvider(Key<T> key) {
        return this.providers.computeIfAbsent(key, k -> {
            if (key.isAutoFactory()) {
                return this.memoized(new ScopeBuilderProvider(key.getDependencyClass()));
            }
            return this.findLocalProvider(key);
        });
    }

    private <T> Provider<T> findLocalProvider(Key<T> key) throws UnsatisfiedDependencyException {
        if (key.isArray()) {
            ArrayProvider tProvider = new ArrayProvider(key.getComponentType());
            return this.memoized(tProvider);
        }
        if (key.isCollection()) {
            ListProvider tProvider = new ListProvider(key.getComponentType());
            return this.memoized(tProvider);
        }
        Class<T> dependencyClass = key.getDependencyClass();
        Class<T> implClass = this.pluginFinder.findPlugin(dependencyClass);
        if (implClass == null) {
            implClass = this.getDefaultImpl(key);
        }
        if (implClass == null && this.isConcrete(dependencyClass) && !this.isSystem(dependencyClass)) {
            implClass = dependencyClass;
        }
        if (implClass != null) {
            return this.memoized(implClass);
        }
        throw new UnsatisfiedDependencyException(key, null);
    }

    private <T> boolean isConcrete(Class<T> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    private <T> Class<? extends T> getDefaultImpl(Key<T> key) {
        Class<?> aClass = this.defaultImpls.get(key);
        return aClass;
    }

    private boolean isSystem(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        Package aPackage = clazz.getPackage();
        return aPackage == null || aPackage.getName().startsWith("java.");
    }

    private static class UnsatisfiedDependencyException
    extends RuntimeException {
        private final Key<?> key;
        private final UnsatisfiedDependencyException inner;

        UnsatisfiedDependencyException(Key<?> key, UnsatisfiedDependencyException inner) {
            super(key.toString());
            this.key = key;
            this.inner = inner;
        }

        <T> InjectionException asInjectionException(Key<T> key) {
            StringBuilder buf = new StringBuilder("Failed to resolve dependency: ");
            UnsatisfiedDependencyException current = this;
            while (current != null) {
                buf.append(current.key.toShortString());
                current = current.inner;
                if (current == null) continue;
                buf.append("/");
            }
            return new InjectionException(key, buf.toString(), (Throwable)this);
        }
    }

    private class ScopeBuilderProvider<T>
    implements Provider<T> {
        private final Class<T> clazz;

        public ScopeBuilderProvider(Class<T> clazz) {
            this.clazz = clazz;
        }

        public T get() {
            return (T)Proxy.newProxyInstance(this.clazz.getClassLoader(), new Class[]{this.clazz}, (proxy, method, args) -> this.create(method, args));
        }

        private Object create(Method method, Object[] args) {
            Builder subBuilder = new Builder(Injector.this, Injector.this.pluginFinder);
            if (method.getParameterCount() > 0) {
                AnnotatedType[] parameterTypes = method.getAnnotatedParameterTypes();
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < args.length; ++i) {
                    Type paramType = parameterTypes[i].getType();
                    String name = Injector.this.findName(parameterAnnotations[i]);
                    Object arg = args[i];
                    subBuilder.bind(new Key(paramType, name), arg);
                }
            }
            Class<?> returnType = method.getReturnType();
            return subBuilder.build().getInstance(new Key((Type)returnType));
        }
    }

    private class ArrayProvider<T>
    implements Provider<T[]> {
        private final ListProvider<T> listProvider;

        ArrayProvider(Class<T> clazz) {
            this.listProvider = new ListProvider<T>(clazz);
        }

        public T[] get() {
            Object[] emptyArray = (Object[])Array.newInstance(((ListProvider)this.listProvider).clazz, 0);
            return this.listProvider.get().toArray(emptyArray);
        }
    }

    private class ListProvider<T>
    implements Provider<List<T>> {
        private final Class<T> clazz;

        ListProvider(Class<T> clazz) {
            this.clazz = clazz;
        }

        public List<T> get() {
            ArrayList<Object> plugins = new ArrayList<Object>();
            for (Class<T> pluginClass : Injector.this.pluginFinder.findPlugins(this.clazz)) {
                plugins.add(Injector.this.inject(pluginClass));
            }
            return Collections.unmodifiableList(plugins);
        }
    }

    private static class MemoizingProvider<T>
    implements Provider<T> {
        private Provider<T> delegate;
        private T instance;

        private MemoizingProvider(Provider<T> delegate) {
            this.delegate = delegate;
        }

        public synchronized T get() {
            if (this.instance == null) {
                this.instance = this.delegate.get();
                this.delegate = null;
            }
            return this.instance;
        }
    }

    public static class Key<T> {
        @Nonnull
        private final Type theInterface;
        private final String name;

        private Key(@Nonnull Type theInterface) {
            this(theInterface, (String)null);
        }

        public Key(Type theInterface, String name) {
            this.theInterface = theInterface;
            this.name = name;
        }

        Class<T> getDependencyClass() {
            return (Class)this.theInterface;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.theInterface.equals(key.theInterface) && Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hash(this.theInterface, this.name);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Key<").append(this.theInterface);
            if (this.name != null) {
                buf.append(" named \"").append(this.name).append("\"");
            }
            buf.append(">");
            return buf.toString();
        }

        String toShortString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.theInterface instanceof Class ? ((Class)this.theInterface).getSimpleName() : this.theInterface.getTypeName());
            if (this.name != null) {
                buf.append(" \"").append(this.name).append("\"");
            }
            return buf.toString();
        }

        public boolean isArray() {
            return this.theInterface instanceof Class && ((Class)this.theInterface).isArray() || this.theInterface instanceof GenericArrayType;
        }

        public boolean isCollection() {
            if (this.theInterface instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)this.theInterface).getRawType();
                return Collection.class.isAssignableFrom((Class)rawType);
            }
            return false;
        }

        Class<?> getComponentType() {
            if (this.isArray()) {
                if (this.theInterface instanceof Class) {
                    return ((Class)this.theInterface).getComponentType();
                }
                if (this.theInterface instanceof GenericArrayType) {
                    Type genericComponentType = ((GenericArrayType)this.theInterface).getGenericComponentType();
                    return (Class)((ParameterizedType)genericComponentType).getRawType();
                }
                throw new InjectionException(this, (Throwable)new IllegalArgumentException());
            }
            if (this.isCollection() && this.theInterface instanceof ParameterizedType) {
                return (Class)((ParameterizedType)this.theInterface).getActualTypeArguments()[0];
            }
            throw new IllegalStateException(this.theInterface + "...?");
        }

        boolean isAutoFactory() {
            return this.theInterface instanceof Class && ((Class)this.theInterface).isAnnotationPresent(AutoFactory.class);
        }
    }

    public static class Builder {
        private final Injector superInjector;
        private final Map<Key<?>, Provider<?>> providers = new HashMap();
        private final Map<Key<?>, Class<?>> explicitImpls = new HashMap();
        private final Map<Key<?>, Class<?>> defaultImpls = new HashMap();
        private final PluginFinder pluginFinder;

        public Builder() {
            this(null, (ClassLoader)null);
        }

        public Builder(ClassLoader classLoader) {
            this(null, classLoader);
        }

        public Builder(Injector superInjector) {
            this(superInjector, (ClassLoader)null);
        }

        public Builder(Injector superInjector, ClassLoader classLoader) {
            this(superInjector, new PluginFinder(classLoader));
        }

        @VisibleForTesting
        Builder(Injector superInjector, PluginFinder pluginFinder) {
            this.superInjector = superInjector;
            this.pluginFinder = pluginFinder;
        }

        public <T> Builder bind(@Nonnull Class<T> type, @Nonnull T instance) {
            return this.bind(new Key((Type)type), instance);
        }

        public <T> Builder bind(Key<T> key, @Nonnull T instance) {
            this.providers.put(key, () -> instance);
            return this;
        }

        public <T> Builder bind(@Nonnull Class<T> type, @Nonnull Class<? extends T> implementingClass) {
            this.explicitImpls.put(new Key((Type)type), implementingClass);
            return this;
        }

        public <T> Builder bindDefault(@Nonnull Class<T> type, @Nonnull Class<? extends T> defaultImplementingClass) {
            this.defaultImpls.put(new Key((Type)type), defaultImplementingClass);
            return this;
        }

        public Injector build() {
            return new Injector(this.superInjector, this.providers, this.explicitImpls, this.defaultImpls, this.pluginFinder);
        }
    }
}

