/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.inject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceConfigurationError;

final class ServiceFinder<S>
implements Iterable<Class<? extends S>> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final ClassLoader loader;
    private LinkedHashMap<String, Class<S>> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceFinder(Class<S> svc, ClassLoader cl) {
        this.service = Objects.requireNonNull(svc, "Service interface cannot be null");
        this.loader = cl == null ? ClassLoader.getSystemClassLoader() : cl;
        this.reload();
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceFinder.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceFinder.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceFinder.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceFinder.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class<?> service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceFinder.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceFinder.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    @Override
    public Iterator<Class<? extends S>> iterator() {
        return new Iterator<Class<? extends S>>(){
            Iterator<Map.Entry<String, Class<S>>> knownProviders;
            {
                this.knownProviders = ServiceFinder.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return ServiceFinder.this.lookupIterator.hasNext();
            }

            @Override
            public Class<S> next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return ServiceFinder.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceFinder<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceFinder<S>(service, loader);
    }

    public static <S> ServiceFinder<S> load(Class<S> service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ServiceFinder.load(service, cl);
    }

    public static <S> ServiceFinder<S> loadInstalled(Class<S> service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return ServiceFinder.load(service, prev);
    }

    public static <S> S loadFromSystemProperty(Class<S> service) {
        try {
            String className = System.getProperty(service.getName());
            if (className != null) {
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass(className);
                return (S)c.newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return ServiceFinder.class.getName() + "[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator<Class<S>> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        private boolean hasNextService() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceFinder.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    ServiceFinder.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceFinder.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        private Class<S> nextService() {
            if (!this.hasNextService()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            Class<?> c = null;
            try {
                c = Class.forName(cn, false, this.loader);
            }
            catch (ClassNotFoundException x) {
                ServiceFinder.fail(this.service, "Provider " + cn + " not found", x);
            }
            if (!this.service.isAssignableFrom(c)) {
                ClassCastException cce = new ClassCastException(this.service.getCanonicalName() + " is not assignable from " + c.getCanonicalName());
                ServiceFinder.fail(this.service, "Provider " + cn + " not a subtype", cce);
            }
            try {
                Class<?> clazz = c;
                ServiceFinder.this.providers.put(cn, clazz);
                return clazz;
            }
            catch (Throwable x) {
                ServiceFinder.fail(this.service, "Provider " + cn + " could not be instantiated", x);
                throw new Error();
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNextService();
        }

        @Override
        public Class<S> next() {
            return this.nextService();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

