/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.robolectric.util.Logger;

public class TempDirectory {
    private static final int DELETE_THREAD_POOL_SIZE = 5;
    private static final Set<TempDirectory> tempDirectoriesToDelete = new HashSet<TempDirectory>();
    private final Path basePath;

    public TempDirectory() {
        this("test-dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempDirectory(String name) {
        try {
            this.basePath = Files.createTempDirectory("robolectric-" + name, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Set<TempDirectory> set = tempDirectoriesToDelete;
        synchronized (set) {
            if (tempDirectoriesToDelete.size() == 0) {
                Runtime.getRuntime().addShutdownHook(new Thread(TempDirectory::clearAllDirectories));
            }
            tempDirectoriesToDelete.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearAllDirectories() {
        ExecutorService deletionExecutorService = Executors.newFixedThreadPool(5);
        Set<TempDirectory> set = tempDirectoriesToDelete;
        synchronized (set) {
            for (TempDirectory undeletedDirectory : tempDirectoriesToDelete) {
                deletionExecutorService.execute(undeletedDirectory::destroy);
            }
        }
        deletionExecutorService.shutdown();
        try {
            deletionExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            deletionExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Path createFile(String name, String contents) {
        Path path = this.basePath.resolve(name);
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            out.write(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("failed writing to " + name, e);
        }
        return path;
    }

    public Path create(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public Path createIfNotExists(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public void destroy() {
        try {
            this.clearDirectory(this.basePath);
            Files.delete(this.basePath);
        }
        catch (IOException ignored) {
            Logger.error("Failed to destroy temp directory", ignored);
        }
    }

    private void clearDirectory(final Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

