/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver;

import jakarta.servlet.Servlet;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.robotframework.remoteserver.cli.CommandLineHelper;
import org.robotframework.remoteserver.library.RemoteLibrary;
import org.robotframework.remoteserver.logging.Jetty2Log4J;
import org.robotframework.remoteserver.servlet.IllegalPathException;
import org.robotframework.remoteserver.servlet.RemoteServerServlet;

public class RemoteServer {
    private static org.apache.commons.logging.Log log = LogFactory.getLog(RemoteServer.class);
    private static int serverPort;
    private static String serverHost;
    protected Server server;
    private RemoteServerServlet servlet = new RemoteServerServlet();

    public RemoteServer() {
        this(0);
    }

    public RemoteServer(int port) {
        this(null, port);
    }

    public RemoteServer(String host, int port) {
        this.server = host != null ? new Server(new InetSocketAddress(host, port)) : new Server(port);
        ServletContextHandler servletContextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", false, false);
        servletContextHandler.addServlet(new ServletHolder((Servlet)this.servlet), "/");
    }

    public int getLocalPort() {
        for (Connector connector : this.server.getConnectors()) {
            serverPort = ((ServerConnector)connector).getLocalPort();
        }
        return serverPort;
    }

    public boolean getAllowStop() {
        return this.servlet.getAllowStop();
    }

    public void setAllowStop(boolean allowed) {
        this.servlet.setAllowStop(allowed);
    }

    public static void main(String[] args) throws Exception {
        RemoteServer.configureLogging();
        CommandLineHelper helper = new CommandLineHelper(args);
        if (helper.getHelpRequested()) {
            System.out.print(helper.getUsage());
            System.exit(0);
        }
        serverPort = helper.getPort();
        serverHost = helper.getHost();
        RemoteServer remoteServer = new RemoteServer(serverHost, serverPort);
        String error = helper.getError();
        if (error == null) {
            try {
                for (String path : helper.getLibraryMap().keySet()) {
                    remoteServer.putLibrary(path, helper.getLibraryMap().get(path));
                }
            }
            catch (IllegalPathException e) {
                error = e.getMessage();
            }
        }
        if (error != null) {
            System.out.println("Error: " + error);
            System.out.println();
            System.out.println(helper.getUsage());
            System.exit(1);
        }
        remoteServer.setAllowStop(helper.getAllowStop());
        remoteServer.start();
    }

    public RemoteLibrary putLibrary(String path, Object library) {
        RemoteLibrary oldLibrary = this.servlet.putLibrary(path, library);
        String name = this.servlet.getLibraryMap().get(path).getName();
        log.info((Object)String.format("Mapped path %s to library %s.", path, name));
        return oldLibrary;
    }

    public RemoteLibrary removeLibrary(String path) {
        return this.servlet.removeLibrary(path);
    }

    public Map<String, RemoteLibrary> getLibraryMap() {
        return this.servlet.getLibraryMap();
    }

    public void stop(int timeoutMS) throws Exception {
        log.info((Object)"Robot Framework remote server stopping");
        if (timeoutMS > 0) {
            this.server.setStopTimeout((long)timeoutMS);
            Thread stopper = new Thread(){

                @Override
                public void run() {
                    try {
                        RemoteServer.this.server.stop();
                    }
                    catch (Throwable e) {
                        log.error((Object)String.format("Failed to stop the server: %s", e.getMessage()), e);
                    }
                }
            };
            stopper.start();
        } else {
            this.server.stop();
        }
    }

    public void stop() throws Exception {
        this.stop(0);
    }

    public void start() throws Exception {
        log.info((Object)"Robot Framework remote server starting");
        this.server.start();
        log.info((Object)String.format("Robot Framework remote server started on port %d.", this.getLocalPort()));
    }

    public static void configureLogging() {
        Configurator.initialize((Configuration)new DefaultConfiguration());
        Configurator.setRootLevel((Level)Level.INFO);
        Log.setLog((Logger)new Jetty2Log4J());
        LogFactory.releaseAll();
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.Log4JLogger");
        log = LogFactory.getLog(RemoteServer.class);
    }
}

