/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.javalib;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.remoteserver.javalib.KeywordOverload;

public class OverloadableKeyword
implements Keyword {
    private Map<Integer, List<KeywordOverload>> keywordMap = new HashMap<Integer, List<KeywordOverload>>();
    private String name;
    private Object keywordBean;
    private boolean usesVarArgs = false;
    private static Log log = LogFactory.getLog(OverloadableKeyword.class);

    public OverloadableKeyword(Object keywordBean, Method method) {
        this.name = method.getName();
        this.keywordBean = keywordBean;
        this.addOverload(method);
    }

    public Object execute(List arguments) {
        return this.execute(arguments, null);
    }

    public Object execute(List arguments, Map kwargs) {
        KeywordOverload selectedKeyword = null;
        Integer argCount = arguments.size();
        if (this.usesVarArgs) {
            for (List<KeywordOverload> kws : this.keywordMap.values()) {
                selectedKeyword = kws.get(0);
            }
        } else if (this.keywordMap.containsKey(argCount)) {
            List<KeywordOverload> kwList = this.keywordMap.get(argCount);
            if (kwList.size() == 1) {
                selectedKeyword = kwList.get(0);
            } else {
                for (KeywordOverload overload : kwList) {
                    if (!overload.canExecute(arguments, kwargs)) continue;
                    selectedKeyword = overload;
                    break;
                }
                if (selectedKeyword == null) {
                    throw new IllegalArgumentException(String.format("No overload of %s can take the given arguments", this.name));
                }
            }
        } else {
            if (this.keywordMap.size() == 1) {
                throw new IllegalArgumentException(String.format("%s takes %d argument(s), received %d.", this.name, this.keywordMap.keySet().toArray()[0], argCount));
            }
            throw new IllegalArgumentException(String.format("No overload of %s takes %d argument(s).", this.name, argCount));
        }
        return selectedKeyword.execute(arguments, kwargs);
    }

    public void addOverload(Method method) {
        Integer argCount = method.getParameterTypes().length;
        if (this.usesVarArgs || !this.keywordMap.isEmpty() && this.hasVariableArgs(method)) {
            log.warn((Object)String.format("Overloads with variable arguments not supported. Ignoring overload %s", method.toString()));
            return;
        }
        if (this.keywordMap.containsKey(argCount)) {
            this.keywordMap.get(argCount).add(new KeywordOverload(this.keywordBean, method));
        } else {
            ArrayList<KeywordOverload> overloadList = new ArrayList<KeywordOverload>();
            overloadList.add(new KeywordOverload(this.keywordBean, method));
            this.keywordMap.put(argCount, overloadList);
        }
        if (this.hasVariableArgs(method)) {
            this.usesVarArgs = true;
        }
    }

    public List<String> getArguments() {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int argCount : this.keywordMap.keySet()) {
            if (argCount < min) {
                min = argCount;
            }
            if (argCount <= max) continue;
            max = argCount;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < max; ++i) {
            if (i < min) {
                arguments.add(String.format("arg%d", i + 1));
                continue;
            }
            arguments.add(String.format("arg%d=", i + 1));
        }
        if (this.usesVarArgs) {
            arguments.set(max - 1, "*varargs");
        }
        return arguments;
    }

    private boolean hasVariableArgs(Method method) {
        Integer argCount = method.getParameterTypes().length;
        return argCount > 0 && method.getParameterTypes()[argCount - 1].isArray();
    }

    public List<String> getArgumentTypes() {
        return null;
    }
}

