/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.library;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robotframework.remoteserver.library.DynamicApiRemoteLibrary;
import org.robotframework.remoteserver.library.RemoteLibrary;
import org.robotframework.remoteserver.library.RemoteLibraryFactory;
import org.robotframework.remoteserver.library.StaticApiRemoteLibrary;

public class DefaultRemoteLibraryFactory
implements RemoteLibraryFactory {
    private static List<Class<?>[]> runKeywordParamArrays = new ArrayList<Class<?>[]>();

    @Override
    public RemoteLibrary createRemoteLibrary(Object library) {
        if (library instanceof RemoteLibrary) {
            return (RemoteLibrary)library;
        }
        List<Method> methods = this.getPublicMethods(library.getClass());
        Method getKeywordNames = this.getGetKeywordNames(methods);
        Method runKeyword = this.getRunKeyword(methods);
        if (getKeywordNames == null || runKeyword == null) {
            return new StaticApiRemoteLibrary(library);
        }
        Method getKeywordArguments = this.getGetKeywordArguments(methods);
        Method getKeywordDocumentation = this.getGetKeywordDocumentation(methods);
        Method getKeywordTags = this.getGetKeywordTags(methods);
        Method getKeywordTypes = this.getGetKeywordTypes(methods);
        return new DynamicApiRemoteLibrary(library, getKeywordNames, runKeyword, getKeywordArguments, getKeywordDocumentation, getKeywordTags, getKeywordTypes);
    }

    private List<Method> getPublicMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            methods.add(m);
        }
        return methods;
    }

    private Method getGetKeywordNames(List<Method> methods) {
        for (Method m : methods) {
            if (!m.getName().equals("getKeywordNames") && !m.getName().equals("get_keyword_names") || m.getReturnType() != String[].class && m.getReturnType() != List.class || m.getParameterTypes().length != 0) continue;
            return m;
        }
        return null;
    }

    private Method getRunKeyword(List<Method> methods) {
        Method matchingMethod = null;
        block0: for (Method m : methods) {
            Object[] pTypes = m.getParameterTypes();
            if (!m.getName().equals("runKeyword") && !m.getName().equals("run_keyword") || !m.getReturnType().equals(Object.class)) continue;
            for (Object[] objectArray : runKeywordParamArrays) {
                if (!Arrays.equals(pTypes, objectArray)) continue;
                if (pTypes.length == 3) {
                    return m;
                }
                matchingMethod = m;
                continue block0;
            }
        }
        return matchingMethod;
    }

    private Method getGetKeywordArguments(List<Method> methods) {
        for (Method m : methods) {
            if (!m.getName().equals("getKeywordArguments") && !m.getName().equals("get_keyword_arguments") || m.getReturnType() != String[].class && m.getReturnType() != List.class || !Arrays.equals(m.getParameterTypes(), new Class[]{String.class})) continue;
            return m;
        }
        return null;
    }

    private Method getGetKeywordDocumentation(List<Method> methods) {
        for (Method m : methods) {
            if (!m.getName().equals("getKeywordDocumentation") && !m.getName().equals("get_keyword_documentation") || m.getReturnType() != String.class || !Arrays.equals(m.getParameterTypes(), new Class[]{String.class})) continue;
            return m;
        }
        return null;
    }

    private Method getGetKeywordTags(List<Method> methods) {
        for (Method m : methods) {
            if (!m.getName().equals("getKeywordTags") && !m.getName().equals("get_keyword_tags") || m.getReturnType() != List.class || !Arrays.equals(m.getParameterTypes(), new Class[]{String.class})) continue;
            return m;
        }
        return null;
    }

    private Method getGetKeywordTypes(List<Method> methods) {
        for (Method m : methods) {
            if (!m.getName().equals("getKeywordTypes") && !m.getName().equals("get_keyword_types") || m.getReturnType() != List.class || !Arrays.equals(m.getParameterTypes(), new Class[]{String.class})) continue;
            return m;
        }
        return null;
    }

    static {
        runKeywordParamArrays.add(new Class[]{String.class, Object[].class, Map.class});
        runKeywordParamArrays.add(new Class[]{String.class, List.class, Map.class});
        runKeywordParamArrays.add(new Class[]{String.class, Object[].class});
        runKeywordParamArrays.add(new Class[]{String.class, List.class});
    }
}

