/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.library;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robotframework.remoteserver.library.RemoteLibrary;

public class DynamicApiRemoteLibrary
implements RemoteLibrary {
    private Object library;
    private Method getKeywordNames;
    private Method runKeyword;
    private Method getKeywordArguments;
    private Method getKeywordDocumentation;
    private Method getKeywordTags;
    private Method getKeywordTypes;

    protected DynamicApiRemoteLibrary(Object library, Method getKeywordNames, Method runKeyword, Method getKeywordArguments, Method getKeywordDocumentation, Method getKeywordTags, Method getKeywordTypes) {
        this.library = library;
        this.getKeywordNames = getKeywordNames;
        this.runKeyword = runKeyword;
        this.getKeywordArguments = getKeywordArguments;
        this.getKeywordDocumentation = getKeywordDocumentation;
        this.getKeywordTags = getKeywordTags;
        this.getKeywordTypes = getKeywordTypes;
    }

    @Override
    public List<String> getKeywordNames() {
        try {
            Object names = this.getKeywordNames.invoke(this.library, new Object[0]);
            if (names instanceof List) {
                return (List)names;
            }
            return Arrays.asList((String[])names);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Object runKeyword(String keyword, List<String> args, Map<String, Object> kwargs) throws Throwable {
        if (kwargs != null && !kwargs.isEmpty() && this.runKeyword.getParameterTypes().length == 2) {
            throw new RuntimeException("This library does not support keyword arguments.");
        }
        Object[] invokeArgs = new Object[this.runKeyword.getParameterTypes().length];
        invokeArgs[0] = keyword;
        Object[] objectArray = invokeArgs[1] = this.runKeyword.getParameterTypes()[1].equals(List.class) ? args : args.toArray();
        if (invokeArgs.length == 3) {
            invokeArgs[2] = kwargs;
        }
        try {
            return this.runKeyword.invoke(this.library, invokeArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public List<String> getKeywordArguments(String keyword) {
        if (this.getKeywordArguments == null) {
            return Arrays.asList("*args");
        }
        try {
            Object args = this.getKeywordArguments.invoke(this.library, keyword);
            if (args instanceof List) {
                return (List)args;
            }
            return Arrays.asList((String[])args);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getKeywordDocumentation(String keyword) {
        if (this.getKeywordDocumentation == null) {
            return "";
        }
        try {
            return (String)this.getKeywordDocumentation.invoke(this.library, keyword);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getKeywordTags(String keyword) {
        if (this.getKeywordTags == null) {
            return new ArrayList<String>();
        }
        try {
            return (List)this.getKeywordTags.invoke(this.library, keyword);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getKeywordTypes(String keyword) {
        if (this.getKeywordTypes == null) {
            return new ArrayList<String>();
        }
        try {
            return (List)this.getKeywordTypes.invoke(this.library, keyword);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.library.getClass().getName();
    }

    @Override
    public Object getImplementation() {
        return this.library;
    }
}

