/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.robotframework.javalib.util.StdStreamRedirecter;
import org.robotframework.remoteserver.servlet.RemoteServerServlet;

public class ServerMethods {
    private Log log;
    private RemoteServerServlet servlet;
    private static List<String> genericExceptions = Arrays.asList("AssertionError", "AssertionFailedError", "Exception", "Error", "RuntimeError", "RuntimeException", "DataError", "TimeoutError", "RemoteError");
    String[] logLevelPrefixes = new String[]{"*TRACE*", "*DEBUG*", "*INFO*", "*HTML*", "*WARN*"};

    public ServerMethods(RemoteServerServlet servlet) {
        this.log = LogFactory.getLog(ServerMethods.class);
        this.servlet = servlet;
    }

    public List<String> get_keyword_names() {
        try {
            List<String> names = this.servlet.getLibrary().getKeywordNames();
            if (names == null || names.size() == 0) {
                throw new RuntimeException("No keywords found in the test library");
            }
            if (!names.contains("stop_remote_server")) {
                names.add("stop_remote_server");
            }
            return names;
        }
        catch (Throwable e) {
            this.log.warn((Object)"", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> run_keyword(String keyword, List<String> args, Map<String, Object> kwargs) {
        StdStreamRedirecter redirector;
        HashMap<String, Object> result;
        block25: {
            result = new HashMap<String, Object>();
            redirector = new StdStreamRedirecter();
            redirector.redirectStdStreams();
            try {
                result.put("status", "PASS");
                Object retObj = "";
                if (keyword.equalsIgnoreCase("stop_remote_server")) {
                    retObj = this.stopRemoteServer();
                } else {
                    try {
                        retObj = this.servlet.getLibrary().runKeyword(keyword, args, kwargs);
                    }
                    catch (Exception e) {
                        if (this.illegalArgumentIn(e)) {
                            retObj = this.servlet.getLibrary().runKeyword(keyword, args, kwargs);
                        }
                        throw e;
                    }
                }
                if (retObj == null || retObj.equals("")) break block25;
                result.put("return", retObj);
            }
            catch (Throwable e) {
                block26: {
                    try {
                        boolean fatal;
                        result.put("status", "FAIL");
                        Throwable thrown = e.getCause() == null ? e : e.getCause();
                        result.put("error", this.getError(thrown));
                        result.put("traceback", ExceptionUtils.getStackTrace((Throwable)thrown));
                        boolean continuable = this.isFlagSet("ROBOT_CONTINUE_ON_FAILURE", thrown);
                        if (continuable) {
                            result.put("continuable", true);
                        }
                        if (!(fatal = this.isFlagSet("ROBOT_EXIT_ON_FAILURE", thrown))) break block26;
                        result.put("fatal", true);
                    }
                    catch (Throwable throwable) {
                        String stdOut = StringUtils.defaultString((String)redirector.getStdOutAsString());
                        String stdErr = StringUtils.defaultString((String)redirector.getStdErrAsString());
                        if (!stdOut.isEmpty() || !stdErr.isEmpty()) {
                            StringBuilder output = new StringBuilder(stdOut);
                            if (!stdOut.isEmpty() && !stdErr.isEmpty()) {
                                if (!stdOut.endsWith("\n")) {
                                    output.append("\n");
                                }
                                boolean addLevel = true;
                                for (String prefix : this.logLevelPrefixes) {
                                    if (!stdErr.startsWith(prefix)) continue;
                                    addLevel = false;
                                    break;
                                }
                                if (addLevel) {
                                    output.append("*INFO*");
                                }
                            }
                            result.put("output", output.append(stdErr).toString());
                        }
                        redirector.resetStdStreams();
                        throw throwable;
                    }
                }
                String stdOut = StringUtils.defaultString((String)redirector.getStdOutAsString());
                String stdErr = StringUtils.defaultString((String)redirector.getStdErrAsString());
                if (!stdOut.isEmpty() || !stdErr.isEmpty()) {
                    StringBuilder output = new StringBuilder(stdOut);
                    if (!stdOut.isEmpty() && !stdErr.isEmpty()) {
                        if (!stdOut.endsWith("\n")) {
                            output.append("\n");
                        }
                        boolean addLevel = true;
                        for (String prefix : this.logLevelPrefixes) {
                            if (!stdErr.startsWith(prefix)) continue;
                            addLevel = false;
                            break;
                        }
                        if (addLevel) {
                            output.append("*INFO*");
                        }
                    }
                    result.put("output", output.append(stdErr).toString());
                }
                redirector.resetStdStreams();
            }
        }
        String stdOut = StringUtils.defaultString((String)redirector.getStdOutAsString());
        String stdErr = StringUtils.defaultString((String)redirector.getStdErrAsString());
        if (!stdOut.isEmpty() || !stdErr.isEmpty()) {
            StringBuilder output = new StringBuilder(stdOut);
            if (!stdOut.isEmpty() && !stdErr.isEmpty()) {
                if (!stdOut.endsWith("\n")) {
                    output.append("\n");
                }
                boolean addLevel = true;
                for (String prefix : this.logLevelPrefixes) {
                    if (!stdErr.startsWith(prefix)) continue;
                    addLevel = false;
                    break;
                }
                if (addLevel) {
                    output.append("*INFO*");
                }
            }
            result.put("output", output.append(stdErr).toString());
        }
        redirector.resetStdStreams();
        return result;
    }

    public Map<String, Object> run_keyword(String keyword, List<String> args) {
        return this.run_keyword(keyword, args, null);
    }

    public List<String> get_keyword_arguments(String keyword) {
        if (keyword.equalsIgnoreCase("stop_remote_server")) {
            return Arrays.asList(new String[0]);
        }
        try {
            List<String> args = this.servlet.getLibrary().getKeywordArguments(keyword);
            return args == null ? Arrays.asList(new String[0]) : args;
        }
        catch (Throwable e) {
            this.log.warn((Object)"", e);
            throw new RuntimeException(e);
        }
    }

    public String get_keyword_documentation(String keyword) {
        if (keyword.equalsIgnoreCase("stop_remote_server")) {
            return "Stops the remote server.\n\nThe server may be configured so that users cannot stop it.";
        }
        try {
            String doc = this.servlet.getLibrary().getKeywordDocumentation(keyword);
            return doc == null ? "" : doc;
        }
        catch (Throwable e) {
            this.log.warn((Object)"", e);
            throw new RuntimeException(e);
        }
    }

    public List<String> get_keyword_tags(String keyword) {
        ArrayList tags = this.servlet.getLibrary().getKeywordTags(keyword);
        return tags == null ? new ArrayList() : tags;
    }

    public List<String> get_keyword_types(String keyword) {
        ArrayList types = this.servlet.getLibrary().getKeywordTypes(keyword);
        return types == null ? new ArrayList() : types;
    }

    public Map<String, Object> get_library_information() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> keywords = this.get_keyword_names();
        for (String k : keywords) {
            result.put(k, this.getLibraryInformation(k));
        }
        return result;
    }

    private Object getLibraryInformation(String keyword) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("args", this.get_keyword_arguments(keyword));
        info.put("types", this.get_keyword_types(keyword));
        info.put("tags", this.get_keyword_tags(keyword));
        info.put("doc", this.get_keyword_documentation(keyword));
        return info;
    }

    public Map<String, Object> stop_remote_server() {
        return this.run_keyword("stop_remote_server", null);
    }

    protected boolean stopRemoteServer() throws Exception {
        if (this.servlet.getAllowStop()) {
            System.out.print("Robot Framework remote server stopping");
            new Thread("remote-server-stopper"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }.start();
        } else {
            System.out.print("This Robot Framework remote server does not allow stopping");
        }
        return true;
    }

    private String getError(Throwable thrown) {
        String simpleName = thrown.getClass().getSimpleName();
        boolean suppressName = this.isFlagSet("ROBOT_SUPPRESS_NAME", thrown);
        if (genericExceptions.contains(simpleName) || suppressName) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)thrown.getMessage(), (CharSequence)simpleName);
        }
        return String.format("%s: %s", thrown.getClass().getName(), thrown.getMessage());
    }

    private boolean isFlagSet(String name, Throwable thrown) {
        boolean flag = false;
        try {
            flag = thrown.getClass().getField(name).getBoolean(thrown);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    protected Object arraysToLists(Object arg) {
        if (arg instanceof Object[]) {
            Object[] array = (Object[])arg;
            List<Object> list = Arrays.asList(array);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.arraysToLists(list.get(i)));
            }
            return list;
        }
        if (arg instanceof Map) {
            Map oldMap = (Map)arg;
            HashMap newMap = new HashMap();
            for (Object key : oldMap.keySet()) {
                newMap.put(key, this.arraysToLists(oldMap.get(key)));
            }
            return newMap;
        }
        return arg;
    }

    private boolean illegalArgumentIn(Throwable t) {
        if (t.getClass().equals(IllegalArgumentException.class)) {
            return true;
        }
        Throwable inner = t;
        while (inner.getCause() != null) {
            if (!(inner = inner.getCause()).getClass().equals(IllegalArgumentException.class)) continue;
            return true;
        }
        return false;
    }
}

