/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.xmlrpc;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.common.TypeFactoryImpl;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.serializer.BooleanSerializer;
import org.apache.xmlrpc.serializer.ByteArraySerializer;
import org.apache.xmlrpc.serializer.DoubleSerializer;
import org.apache.xmlrpc.serializer.I4Serializer;
import org.apache.xmlrpc.serializer.ListSerializer;
import org.apache.xmlrpc.serializer.ObjectArraySerializer;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.robotframework.remoteserver.xmlrpc.ArrayToListParser;
import org.robotframework.remoteserver.xmlrpc.ByteArrayToStringParser;
import org.robotframework.remoteserver.xmlrpc.IterableSerializer;
import org.robotframework.remoteserver.xmlrpc.MapSerializer;
import org.robotframework.remoteserver.xmlrpc.StringSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TypeFactory
extends TypeFactoryImpl {
    private static final TypeSerializer STRING_SERIALIZER = new StringSerializer();
    private static final TypeSerializer I4_SERIALIZER = new I4Serializer();
    private static final TypeSerializer DOUBLE_SERIALIZER = new DoubleSerializer();
    private static final TypeSerializer BOOLEAN_SERIALIZER = new BooleanSerializer();
    private static final TypeSerializer NULL_SERIALIZER = new org.apache.xmlrpc.serializer.StringSerializer(){

        public void write(ContentHandler pHandler, Object pObject) throws SAXException {
            this.write(pHandler, null, "");
        }
    };
    private static final TypeSerializer CHAR_ARRAY_SERIALIZER = new TypeSerializerImpl(){

        public void write(ContentHandler pHandler, Object pObject) throws SAXException {
            char[] chars = (char[])pObject;
            this.write(pHandler, null, chars);
        }
    };
    private TypeSerializer primitiveArraySerializer;
    private static final TypeParser BYTE_ARRAY_PARSER = new ByteArrayToStringParser();

    public TypeFactory(XmlRpcController pController) {
        super(pController);
    }

    public TypeSerializer getSerializer(XmlRpcStreamConfig pConfig, Object pObject) throws SAXException {
        if (pObject == null) {
            return NULL_SERIALIZER;
        }
        if (pObject instanceof String) {
            return STRING_SERIALIZER;
        }
        if (pObject instanceof Integer || pObject instanceof Short || pObject instanceof Byte) {
            return I4_SERIALIZER;
        }
        if (pObject instanceof Boolean) {
            return BOOLEAN_SERIALIZER;
        }
        if (pObject instanceof Double || pObject instanceof Float) {
            return DOUBLE_SERIALIZER;
        }
        if (pObject instanceof Object[]) {
            return new ObjectArraySerializer((org.apache.xmlrpc.common.TypeFactory)this, pConfig);
        }
        if (pObject instanceof List) {
            return new ListSerializer((org.apache.xmlrpc.common.TypeFactory)this, pConfig);
        }
        if (pObject instanceof Map) {
            return new MapSerializer((org.apache.xmlrpc.common.TypeFactory)this, pConfig);
        }
        if (pObject instanceof Iterable) {
            return new IterableSerializer((org.apache.xmlrpc.common.TypeFactory)this, pConfig);
        }
        if (pObject instanceof char[]) {
            return CHAR_ARRAY_SERIALIZER;
        }
        if (pObject instanceof byte[]) {
            return new ByteArraySerializer();
        }
        if (pObject.getClass().isArray()) {
            this.primitiveArraySerializer = new ObjectArraySerializer((org.apache.xmlrpc.common.TypeFactory)this, pConfig){

                protected void writeData(ContentHandler pHandler, Object pObject) throws SAXException {
                    Serializable[] array;
                    if (pObject instanceof byte[]) {
                        array = ArrayUtils.toObject((byte[])((byte[])pObject));
                    } else if (pObject instanceof short[]) {
                        array = ArrayUtils.toObject((short[])((short[])pObject));
                    } else if (pObject instanceof int[]) {
                        array = ArrayUtils.toObject((int[])((int[])pObject));
                    } else if (pObject instanceof long[]) {
                        array = ArrayUtils.toObject((long[])((long[])pObject));
                    } else if (pObject instanceof float[]) {
                        array = ArrayUtils.toObject((float[])((float[])pObject));
                    } else if (pObject instanceof double[]) {
                        array = ArrayUtils.toObject((double[])((double[])pObject));
                    } else if (pObject instanceof boolean[]) {
                        array = ArrayUtils.toObject((boolean[])((boolean[])pObject));
                    } else {
                        throw new SAXException(String.format("Array of type %s[] not handled!", pObject.getClass().getComponentType().getName()));
                    }
                    super.writeData(pHandler, (Object)array);
                }
            };
            return this.primitiveArraySerializer;
        }
        return STRING_SERIALIZER;
    }

    public TypeParser getParser(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, String pURI, String pLocalName) {
        if ("array".equals(pLocalName)) {
            return new ArrayToListParser(pConfig, pContext, (org.apache.xmlrpc.common.TypeFactory)this);
        }
        return super.getParser(pConfig, pContext, pURI, pLocalName);
    }
}

