/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.robotframework.mavenplugin.Arguments;
import org.robotframework.mavenplugin.LibDocMojo;
import org.robotframework.mavenplugin.harvesters.ClassNameHarvester;
import org.robotframework.mavenplugin.harvesters.HarvestUtils;
import org.robotframework.mavenplugin.harvesters.ResourceNameHarvester;
import org.robotframework.mavenplugin.harvesters.SourceFileNameHarvester;

public class LibDocConfiguration {
    private File outputDirectory;
    private File outputFile;
    private String name;
    private String version;
    private String libraryOrResourceFile;
    private File[] extraPathDirectories;
    private File defaultExtraPath;

    public List<String[]> generateRunArguments(File projectBaseDir) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        ArrayList<String> fileArguments = this.harvestResourceOrFileCandidates(projectBaseDir, this.libraryOrResourceFile);
        boolean multipleOutputs = fileArguments.size() > 1;
        for (String fileArgument : fileArguments) {
            Arguments generatedArguments = this.generateLibdocArgumentList(projectBaseDir, multipleOutputs, fileArgument);
            result.add(generatedArguments.toArray());
        }
        return result;
    }

    private Arguments generateLibdocArgumentList(File projectBaseDir, boolean multipleOutputs, String fileArgument) {
        Arguments result = new Arguments();
        result.add("libdoc");
        if (multipleOutputs) {
            result.addNonEmptyStringToArguments(HarvestUtils.extractName(fileArgument), "--name");
        } else {
            result.addNonEmptyStringToArguments(this.name, "--name");
        }
        result.addNonEmptyStringToArguments(this.version, "--version");
        result.addFileListToArguments(this.getExtraPathDirectoriesWithDefault(), "--pythonpath");
        result.add(fileArgument);
        if (multipleOutputs) {
            String normalizedArgument = HarvestUtils.isAbsolutePathFragment(fileArgument) ? HarvestUtils.removePrefixDirectory(projectBaseDir, fileArgument) : fileArgument;
            result.add(this.outputDirectory + File.separator + HarvestUtils.generateIdName(normalizedArgument) + HarvestUtils.extractExtension(this.outputFile.getName()));
        } else if (this.outputFile.getName().contains("*")) {
            File tf = new File(fileArgument);
            result.add(this.outputDirectory + File.separator + tf.getName() + HarvestUtils.extractExtension(this.outputFile.getName()));
        } else {
            result.add(this.outputDirectory + File.separator + this.outputFile.getName());
        }
        return result;
    }

    private ArrayList<String> harvestResourceOrFileCandidates(File projectBaseDir, String pattern) {
        File libOrResource = new File(pattern);
        ArrayList<String> fileArguments = new ArrayList<String>();
        if (libOrResource.isFile()) {
            fileArguments.add(libOrResource.getAbsolutePath());
        } else if (HarvestUtils.hasDirectoryStructure(pattern)) {
            SourceFileNameHarvester harv = new SourceFileNameHarvester(projectBaseDir);
            fileArguments.addAll(harv.harvest(pattern));
        } else {
            SourceFileNameHarvester harv = new SourceFileNameHarvester(projectBaseDir);
            Set<String> harvested = harv.harvest(pattern);
            if (harvested.size() > 0) {
                fileArguments.addAll(harvested);
            } else {
                ClassNameHarvester charv = new ClassNameHarvester();
                harvested = charv.harvest(pattern);
                if (harvested.size() > 0) {
                    fileArguments.addAll(harvested);
                } else {
                    ResourceNameHarvester rharv = new ResourceNameHarvester();
                    fileArguments.addAll(rharv.harvest(pattern));
                }
            }
        }
        return fileArguments;
    }

    private List<File> getExtraPathDirectoriesWithDefault() {
        if (this.extraPathDirectories == null) {
            return Collections.singletonList(this.defaultExtraPath);
        }
        return Arrays.asList(this.extraPathDirectories);
    }

    public void ensureOutputDirectoryExists() throws IOException {
        if (this.outputDirectory == null) {
            String baseDir = System.getProperty("basedir");
            if (baseDir == null) {
                baseDir = ".";
            }
            this.outputDirectory = new File(this.joinPaths(baseDir, "target", "robotframework", "libdoc"));
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Target output directory cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private String joinPaths(String ... parts) {
        return StringUtils.join((Object[])parts, (String)File.separator);
    }

    public void populateDefaults(LibDocMojo defaults) {
        if (this.outputDirectory == null) {
            this.outputDirectory = defaults.defaultLibdocOutputDirectory;
        }
        this.defaultExtraPath = defaults.libdocDefaultExtraPath;
    }
}

