/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin.harvesters;

import java.io.File;

public class HarvestUtils {
    public static final String JAVA_FILE_EXT = ".java";

    public static String extractName(String harvestedName) {
        String result = "";
        int indexOfSlash = harvestedName.lastIndexOf(47);
        int indexOfBackSlash = harvestedName.lastIndexOf(92);
        if (indexOfSlash >= 0 || indexOfBackSlash >= 0) {
            int index = Math.max(indexOfSlash, indexOfBackSlash);
            if (index + 1 != harvestedName.length()) {
                result = harvestedName.endsWith(JAVA_FILE_EXT) ? harvestedName.substring(index + 1, harvestedName.length() - JAVA_FILE_EXT.length()) : harvestedName.substring(index + 1);
            }
        } else if (harvestedName.endsWith(JAVA_FILE_EXT)) {
            result = harvestedName.substring(0, harvestedName.length() - JAVA_FILE_EXT.length());
        } else {
            int indexOfDot = harvestedName.lastIndexOf(46);
            if (indexOfDot + 1 != harvestedName.length()) {
                result = harvestedName.substring(indexOfDot + 1);
            }
        }
        return result;
    }

    public static int calculateMinimumPatternIndex(String antLikePattern) {
        int indexOfStar = antLikePattern.indexOf(42);
        int indexOfQuestionMark = antLikePattern.indexOf(63);
        int minPatternIndex = indexOfStar >= 0 ? (indexOfQuestionMark >= 0 ? Math.min(indexOfStar, indexOfQuestionMark) : indexOfStar) : (indexOfQuestionMark >= 0 ? indexOfQuestionMark : -1);
        return minPatternIndex;
    }

    public static String generateIdName(String harvestedName) {
        return harvestedName.replaceAll("/|\\.|\\\\", "_");
    }

    public static boolean isAbsolutePathFragment(String fragment) {
        return new File(fragment).isAbsolute();
    }

    public static boolean hasDirectoryStructure(String fragment) {
        return fragment.indexOf(47) >= 0 || fragment.indexOf(92) >= 0;
    }

    public static String extractExtension(String filename) {
        String result = "";
        int indexOfDot = filename.lastIndexOf(46);
        if (indexOfDot >= 0) {
            result = filename.substring(indexOfDot);
        }
        return result;
    }

    public static String removePrefixDirectory(File projectBaseDir, String fileArgument) {
        String result = fileArgument;
        String prefix = projectBaseDir.getAbsolutePath() + File.separator;
        if (fileArgument.startsWith(prefix)) {
            result = fileArgument.substring(prefix.length());
        }
        return result;
    }
}

