/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Arrays;
import java.util.Objects;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;

public class ColumnFamilyHandle
extends RocksObject {
    private final RocksDB rocksDB_;

    ColumnFamilyHandle(RocksDB rocksDB, long l) {
        super(l);
        assert (rocksDB != null);
        this.rocksDB_ = rocksDB;
    }

    public byte[] getName() {
        return this.getName(this.nativeHandle_);
    }

    public int getID() {
        return this.getID(this.nativeHandle_);
    }

    public ColumnFamilyDescriptor getDescriptor() throws RocksDBException {
        assert (this.isOwningHandle());
        return this.getDescriptor(this.nativeHandle_);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ColumnFamilyHandle columnFamilyHandle = (ColumnFamilyHandle)object;
        return this.rocksDB_.nativeHandle_ == columnFamilyHandle.rocksDB_.nativeHandle_ && this.getID() == columnFamilyHandle.getID() && Arrays.equals(this.getName(), columnFamilyHandle.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getID(), this.rocksDB_.nativeHandle_);
    }

    @Override
    protected void disposeInternal() {
        if (this.rocksDB_.isOwningHandle()) {
            this.disposeInternal(this.nativeHandle_);
        }
    }

    private native byte[] getName(long var1);

    private native int getID(long var1);

    private native ColumnFamilyDescriptor getDescriptor(long var1) throws RocksDBException;

    @Override
    protected final native void disposeInternal(long var1);
}

