/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.romaframework.aspect.authentication.AuthenticationAspectAbstract;
import org.romaframework.aspect.authentication.AuthenticationException;
import org.romaframework.aspect.authentication.UserObjectPermissionListener;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.aspect.session.SessionAccount;
import org.romaframework.aspect.session.SessionInfo;
import org.romaframework.aspect.session.SessionListener;
import org.romaframework.core.Roma;
import org.romaframework.core.flow.Controller;
import org.romaframework.core.flow.SchemaFieldListener;
import org.romaframework.core.schema.SchemaAction;
import org.romaframework.core.schema.SchemaClass;
import org.romaframework.core.schema.SchemaEvent;
import org.romaframework.core.schema.SchemaField;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;
import org.romaframework.module.users.domain.BaseFunction;
import org.romaframework.module.users.domain.BaseProfile;
import org.romaframework.module.users.repository.BaseAccountRepository;
import org.romaframework.module.users.view.domain.AccountManagementUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersAuthentication
extends AuthenticationAspectAbstract
implements UserObjectPermissionListener,
SessionListener,
SchemaFieldListener {
    public static final String ANONYMOUS_PROFILE_NAME = "anonymous";
    public static final String PAR_ALGORITHM = "algorithm";
    protected static BaseProfile publicProfile;
    protected static final int ERROR_SLEEP_TIME = 1000;
    private BaseProfile anonymousProfile;
    private boolean loadedAnonymousProfile = false;
    private boolean singleSessionPerUser = false;

    public UsersAuthentication() {
        Controller.getInstance().registerListener(SessionListener.class, (Object)this);
        Controller.getInstance().registerListener(SchemaFieldListener.class, (Object)this);
        Controller.getInstance().registerListener(UserObjectPermissionListener.class, (Object)this);
    }

    public Object authenticate(String iUserName, String iUserPasswd, Map<String, String> iParameters) throws AuthenticationException {
        String iMessage;
        BaseAccountRepository repository = (BaseAccountRepository)Roma.repository(BaseAccount.class);
        QueryByFilter filter = new QueryByFilter(BaseAccount.class);
        filter.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)iUserName);
        filter.setMode("full");
        filter.setStrategy((byte)2);
        BaseAccount account = (BaseAccount)repository.findFirstByCriteria((Query)filter);
        if (account == null) {
            iMessage = Roma.i18n().get("UsersAuthentication.accountNotFound.label", new Object[]{iUserName});
            if (iMessage == null) {
                iMessage = "User or Password not correct";
            }
            this.throwException(iMessage);
        }
        try {
            if (!this.checkPassword(account.getPassword(), iUserPasswd)) {
                iMessage = Roma.i18n().get("UsersAuthentication.wrongPassword.label", new Object[]{iUserName});
                if (iMessage == null) {
                    iMessage = "User or Password not correct";
                }
                this.throwException(iMessage);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        QueryByFilter byFilter = new QueryByFilter(BaseAccountStatus.class);
        byFilter.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)"Unactive");
        BaseAccountStatus accountStatusInactive = (BaseAccountStatus)Roma.context().persistence().queryOne((Query)byFilter);
        if (AccountManagementUtility.isAccountExpired(account)) {
            account.setStatus(accountStatusInactive);
            account.setSignedOn(null);
            account = (BaseAccount)repository.update(account, (byte)2);
        }
        QueryByFilter byFilterAct = new QueryByFilter(BaseAccountStatus.class);
        byFilterAct.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)"Active");
        BaseAccountStatus accountStatus = (BaseAccountStatus)Roma.context().persistence().queryOne((Query)byFilterAct);
        if (account.getStatus() == null || !account.getStatus().equals(accountStatus)) {
            String iMessage2 = Roma.i18n().get("UsersAuthentication.accountDisabled.label", new Object[]{iUserName});
            if (iMessage2 == null) {
                iMessage2 = "Account " + iUserName + " is not active";
            }
            this.throwException(iMessage2);
        }
        if (this.isSingleSessionPerUser()) {
            this.dropExistingSessions(account);
        }
        account.setSignedOn(new Date());
        account = (BaseAccount)repository.update(account, (byte)2);
        Roma.session().getActiveSessionInfo().setAccount((SessionAccount)account);
        return account;
    }

    protected void dropExistingSessions(BaseAccount account) {
    }

    public boolean checkPassword(String iPassword, String iPasswordToCheck) throws NoSuchAlgorithmException {
        if (this.getEncryptionAlgorithm() == null) {
            if (iPassword == null && iPasswordToCheck == null) {
                return true;
            }
            return iPasswordToCheck != null && iPassword != null && iPasswordToCheck.equals(iPassword);
        }
        return this.encryptPassword(iPasswordToCheck).equals(iPassword);
    }

    protected void throwException(String iMessage) throws AuthenticationException {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new AuthenticationException(iMessage);
    }

    public boolean allow(Object iProfile, String iFunctionName) {
        if (iProfile == null) {
            iProfile = this.getAnonymousProfile();
        }
        if (iProfile == null) {
            return true;
        }
        BaseProfile userProfile = (BaseProfile)iProfile;
        ArrayList<BaseProfile> profiles = new ArrayList<BaseProfile>();
        for (BaseProfile profile = userProfile; profile != null; profile = profile.getParent()) {
            profiles.add(profile);
        }
        BaseProfile.Mode mode = userProfile.getParent() != null ? ((BaseProfile)profiles.get(profiles.size() - 1)).getMode() : userProfile.getMode();
        boolean allowed = mode != null && mode == BaseProfile.Mode.ALLOW_ALL_BUT;
        for (BaseProfile profIter : profiles) {
            BaseFunction function;
            if (profIter.getFunctions() == null || (function = profIter.getFunctions().get(iFunctionName)) == null) continue;
            allowed = function.isAllow();
            break;
        }
        return allowed;
    }

    public void logout() throws AuthenticationException {
    }

    public boolean allowClass(SchemaClass iClass) {
        if (iClass == null) {
            return true;
        }
        if (!this.status.equals("up")) {
            return true;
        }
        BaseProfile profile = this.getCurrentProfile();
        return this.allow(profile, iClass.getName());
    }

    private boolean allow(String iFunctionName) {
        BaseProfile profile = this.getCurrentProfile();
        return this.allow(profile, iFunctionName);
    }

    public boolean allowField(SchemaField iField) {
        if (!this.status.equals("up")) {
            return true;
        }
        return this.allow(iField.getFullName());
    }

    public boolean allowAction(SchemaAction iAction) {
        if (!this.status.equals("up")) {
            return true;
        }
        return this.allow(iAction.getFullName());
    }

    public boolean allowEvent(SchemaEvent iEvent) {
        if (!this.status.equals("up")) {
            return true;
        }
        return this.allow(iEvent.getFullName());
    }

    public BaseProfile getCurrentProfile() {
        BaseAccount account = (BaseAccount)this.getCurrentAccount();
        if (account == null) {
            return this.getAnonymousProfile();
        }
        return account.getProfile();
    }

    public void onSessionCreating(SessionInfo iSession) {
    }

    public void onSessionDestroying(SessionInfo iSession) {
        this.logout();
    }

    public void startup() {
        super.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseProfile getAnonymousProfile() {
        if (this.loadedAnonymousProfile) {
            return null;
        }
        if (!this.loadedAnonymousProfile && this.anonymousProfile == null) {
            UsersAuthentication usersAuthentication = this;
            synchronized (usersAuthentication) {
                if (this.anonymousProfile == null) {
                    QueryByFilter query = new QueryByFilter(BaseProfile.class);
                    query.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)ANONYMOUS_PROFILE_NAME);
                    query.setMode("full");
                    query.setStrategy((byte)2);
                    this.anonymousProfile = (BaseProfile)Roma.context().persistence().queryOne((Query)query);
                    this.loadedAnonymousProfile = true;
                }
            }
        }
        return this.anonymousProfile;
    }

    public boolean isSingleSessionPerUser() {
        return this.singleSessionPerUser;
    }

    public void setSingleSessionPerUser(boolean singleSessionPerUser) {
        this.singleSessionPerUser = singleSessionPerUser;
    }

    public Object onAfterFieldRead(Object iContent, SchemaField iField, Object iCurrentValue) {
        if (iCurrentValue instanceof Collection) {
            Iterator iter = ((Collection)iCurrentValue).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o == null || this.allowClass(Roma.schema().getSchemaClass(o.getClass()))) continue;
                iter.remove();
            }
        }
        if (iCurrentValue instanceof Map) {
            Map map = (Map)iCurrentValue;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry iter = iterator.next();
                Object key = iter.getKey();
                if (key != null && !this.allowClass(Roma.schema().getSchemaClass(key.getClass()))) {
                    iterator.remove();
                    continue;
                }
                if (iter.getValue() == null || this.allowClass(Roma.schema().getSchemaClass(iter.getValue().getClass()))) continue;
                iterator.remove();
            }
        }
        return iCurrentValue;
    }

    public Object onAfterFieldWrite(Object iContent, SchemaField iField, Object iCurrentValue) {
        return iCurrentValue;
    }

    public Object onBeforeFieldRead(Object iContent, SchemaField iField, Object iCurrentValue) {
        return IGNORED;
    }

    public Object onBeforeFieldWrite(Object iContent, SchemaField iField, Object iCurrentValue) {
        return IGNORED;
    }
}

