/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.core.Roma;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;
import org.romaframework.module.users.domain.BaseProfile;
import org.romaframework.module.users.repository.BaseProfileRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersHelper {
    private static UsersHelper instance = new UsersHelper();

    public List<BaseProfile> getProfileList() {
        return ((BaseProfileRepository)((Object)Roma.component(BaseProfileRepository.class))).getAll();
    }

    public BaseProfile[] getProfileArray() {
        List<BaseProfile> profiles = this.getProfileList();
        BaseProfile[] profileArray = new BaseProfile[profiles.size()];
        if (profiles.size() > 0) {
            profiles.toArray(profileArray);
        }
        return profileArray;
    }

    public BaseProfile getProfile(String iName) {
        QueryByFilter query = new QueryByFilter(BaseProfile.class);
        query.setStrategy((byte)2);
        if (iName != null) {
            query.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)iName);
        }
        return (BaseProfile)Roma.context().persistence().queryOne((Query)query);
    }

    public BaseProfile setProfile(String iName, BaseProfile.Mode iMode) {
        BaseProfile profile = new BaseProfile(iName, null, iMode, "HomePage");
        return this.setProfile(profile);
    }

    public BaseProfile setProfile(BaseProfile iProfile) {
        List<BaseProfile> profiles = this.getProfileList();
        if (!profiles.contains(iProfile)) {
            iProfile = (BaseProfile)Roma.context().persistence().createObject((Object)iProfile);
        }
        return iProfile;
    }

    public List<BaseAccount> getAccountList(String iProfileName) {
        return this.getAccountList(this.getProfile(iProfileName));
    }

    public List<BaseAccount> getAccountList(BaseProfile iProfile) {
        QueryByFilter filter = new QueryByFilter(BaseAccount.class);
        filter.setStrategy((byte)2);
        if (iProfile != null) {
            filter.addItem("profile", QueryByFilter.FIELD_EQUALS, (Object)iProfile);
        }
        List result = Roma.context().persistence().query((Query)filter);
        return result;
    }

    public BaseAccount getAccount(String iProfileName, String iName) {
        return this.getAccount(this.getProfile(iProfileName), iName);
    }

    public BaseAccount getAccount(BaseProfile iProfile, String iName) {
        QueryByFilter filter = new QueryByFilter(BaseAccount.class);
        filter.setStrategy((byte)2);
        if (iProfile != null) {
            filter.addItem("profile", QueryByFilter.FIELD_EQUALS, (Object)iProfile);
        }
        filter.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)iName);
        return (BaseAccount)Roma.context().persistence().queryOne((Query)filter);
    }

    public BaseAccount setAccount(String iProfileName, String iName, String iPassword) throws NoSuchAlgorithmException {
        return this.setAccount(this.getProfile(iProfileName), iName, iPassword, null);
    }

    public BaseAccount setAccount(BaseProfile iProfile, String iName, String iPassword) throws NoSuchAlgorithmException {
        return this.setAccount(iProfile, iName, iPassword, null);
    }

    public BaseAccount setAccount(String iProfileName, String iName, String iPassword, BaseAccountStatus iStatus) throws NoSuchAlgorithmException {
        return this.setAccount(this.getProfile(iProfileName), iName, iPassword, iStatus);
    }

    public BaseAccount setAccount(BaseProfile iProfile, String iName, String iPassword, BaseAccountStatus iStatus) throws NoSuchAlgorithmException {
        if (iStatus == null) {
            QueryByFilter byFilterAct = new QueryByFilter(BaseAccountStatus.class);
            byFilterAct.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)"Active");
            iStatus = (BaseAccountStatus)Roma.context().persistence().queryOne((Query)byFilterAct);
        }
        BaseAccount iAccount = new BaseAccount();
        iAccount.setName(iName);
        iAccount.setPassword(iPassword);
        iAccount.setProfile(iProfile);
        iAccount.setStatus(iStatus);
        return this.storeAccount(iAccount);
    }

    public BaseAccount setAccount(BaseAccount iAccount) {
        return this.storeAccount(iAccount);
    }

    private BaseAccount storeAccount(BaseAccount iAccount) {
        List<BaseAccount> result = this.getAccountList(iAccount.getProfile());
        if (!result.contains(iAccount)) {
            iAccount = (BaseAccount)Roma.context().persistence().createObject((Object)iAccount);
        }
        return iAccount;
    }

    public static UsersHelper getInstance() {
        return instance;
    }
}

