/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.domain;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.romaframework.frontend.domain.crud.CRUDHelper;
import org.romaframework.module.users.domain.BaseFunction;
import org.romaframework.module.users.view.domain.baseprofile.BaseProfileSelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProfile
implements Serializable,
Principal {
    private static final long serialVersionUID = 2147431210150249521L;
    protected String name;
    protected BaseProfile parent;
    protected Mode mode;
    protected Map<String, BaseFunction> functions;
    protected String homePage;
    protected String notes;
    public static final byte MODE_ALLOW_ALL_BUT = 0;
    public static final byte MODE_DENY_ALL_BUT = 1;

    public BaseProfile() {
    }

    public BaseProfile(String iName, BaseProfile iParent, Mode iMode, String iHomePage) {
        this.name = iName;
        this.parent = iParent;
        this.mode = iMode;
        this.homePage = iHomePage;
        this.functions = new TreeMap<String, BaseFunction>();
    }

    public void onParent() {
        CRUDHelper.show(BaseProfileSelect.class, (Object)this, (String)"parent");
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public BaseProfile setMode(Mode iInheritMode) {
        this.mode = iInheritMode;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BaseProfile setName(String name) {
        this.name = name;
        return this;
    }

    public BaseProfile getParent() {
        return this.parent;
    }

    public BaseProfile setParent(BaseProfile parent) {
        this.parent = parent;
        return this;
    }

    public Map<String, BaseFunction> getFunctions() {
        return this.functions;
    }

    public BaseProfile setFunctions(Map<String, BaseFunction> functions) {
        this.functions = functions;
        return this;
    }

    public BaseProfile addFunction(String iName, boolean iAllowed) {
        if (this.functions == null) {
            this.functions = new HashMap<String, BaseFunction>();
        }
        BaseFunction func = new BaseFunction(iName, iAllowed);
        this.functions.put(iName, func);
        return this;
    }

    public BaseProfile removeFunction(String iKey) {
        this.functions.remove(iKey);
        return this;
    }

    public String getNotes() {
        return this.notes;
    }

    public BaseProfile setNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public BaseProfile setHomePage(String homePage) {
        this.homePage = homePage;
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseProfile other = (BaseProfile)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ALLOW_ALL_BUT("Allow all but"),
        DENY_ALL_BUT("Deny all but");

        private String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

