/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.install;

import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import org.romaframework.aspect.persistence.PersistenceAspect;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.core.Roma;
import org.romaframework.core.install.AbstractApplicationInstaller;
import org.romaframework.module.users.UsersHelper;
import org.romaframework.module.users.domain.ActivityLogCategory;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;
import org.romaframework.module.users.domain.BaseFunction;
import org.romaframework.module.users.domain.BaseProfile;
import org.romaframework.module.users.repository.ActivityLogCategoryRepository;
import org.romaframework.module.users.repository.BaseAccountRepository;
import org.romaframework.module.users.repository.BaseAccountStatusRepository;

public class UsersApplicationInstaller
extends AbstractApplicationInstaller {
    public static final String PROFILE_ADMINISTRATOR = "Administrator";
    public static final String PROFILE_BASIC = "Basic";
    public static final String ACCOUNT_ADMIN = "admin";
    public static final String ACCOUNT_USER = "user";
    public static final String ACCOUNT_SEPARATOR = ".";
    protected BaseProfile pAnonymous;
    protected BaseProfile pAdmin;
    protected BaseProfile pBasic;
    protected BaseAccountStatus defStatus;

    public boolean alreadyInstalled() {
        return ((BaseAccountRepository)((Object)Roma.component(BaseAccountRepository.class))).countByCriteria((Query)new QueryByFilter(BaseAccount.class)) != 0L;
    }

    public synchronized void install() {
        PersistenceAspect db = Roma.context().persistence();
        this.createStatuses(db);
        this.createProfiles();
        try {
            this.createAccounts();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public synchronized void install(Object obj) {
        this.install();
    }

    protected void createStatuses(PersistenceAspect db) {
        BaseAccountStatusRepository repoStatus = (BaseAccountStatusRepository)((Object)Roma.component(BaseAccountStatusRepository.class));
        this.defStatus = (BaseAccountStatus)repoStatus.create(new BaseAccountStatus("Active"), (byte)2);
        repoStatus.create(new BaseAccountStatus("Unactive"));
        repoStatus.create(new BaseAccountStatus("Suspended"));
        ActivityLogCategoryRepository repoCategory = (ActivityLogCategoryRepository)((Object)Roma.component(ActivityLogCategoryRepository.class));
        repoCategory.create(new ActivityLogCategory("System"));
        repoCategory.create(new ActivityLogCategory("Login"));
        repoCategory.create(new ActivityLogCategory("Administration"));
    }

    protected void createAccounts() throws NoSuchAlgorithmException {
        BaseAccount aAdmin = new BaseAccount();
        aAdmin.setName(ACCOUNT_ADMIN);
        aAdmin.setPassword(ACCOUNT_ADMIN);
        aAdmin.setSignedOn(new Date());
        aAdmin.setStatus(this.defStatus);
        aAdmin.setLastModified(aAdmin.getSignedOn());
        aAdmin.setProfile(this.pAdmin);
        UsersHelper.getInstance().setAccount(aAdmin);
        BaseAccount uUser = new BaseAccount();
        uUser.setName(ACCOUNT_USER);
        uUser.setPassword(ACCOUNT_USER);
        uUser.setSignedOn(new Date());
        uUser.setStatus(this.defStatus);
        uUser.setLastModified(uUser.getSignedOn());
        uUser.setProfile(this.pBasic);
        UsersHelper.getInstance().setAccount(uUser);
    }

    protected void createProfiles() {
        this.pAnonymous = new BaseProfile();
        this.pAnonymous.setName("anonymous");
        this.pAnonymous.setHomePage("HomePage");
        this.pAnonymous.setFunctions(new HashMap<String, BaseFunction>());
        this.pAnonymous.setMode(BaseProfile.Mode.ALLOW_ALL_BUT);
        UsersHelper.getInstance().setProfile(this.pAnonymous);
        this.pAdmin = new BaseProfile();
        this.pAdmin.setName(PROFILE_ADMINISTRATOR);
        this.pAdmin.setHomePage("HomePageAdmin");
        this.pAdmin.setMode(BaseProfile.Mode.ALLOW_ALL_BUT);
        UsersHelper.getInstance().setProfile(this.pAdmin);
        this.pBasic = new BaseProfile();
        this.pBasic.setName(PROFILE_BASIC);
        this.pBasic.setHomePage("HomePage");
        this.pBasic.setMode(BaseProfile.Mode.ALLOW_ALL_BUT);
        UsersHelper.getInstance().setProfile(this.pBasic);
    }
}

