/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.romaframework.core.Roma;
import org.romaframework.module.users.UsersModule;
import org.romaframework.module.users.domain.BaseAccount;

public class AccountManagementUtility {
    public static final long DAY_MILLISECONDS = 86400000L;

    public static boolean isPasswordExpired(BaseAccount account) {
        Integer period = ((UsersModule)((Object)Roma.component(UsersModule.class))).getPasswordPeriod();
        return period != null && Math.round((new Date().getTime() - account.getLastPasswordUpdate().getTime()) / 86400000L) > period;
    }

    public static boolean isAccountExpired(BaseAccount account) {
        Integer period = ((UsersModule)((Object)Roma.component(UsersModule.class))).getAccountPeriod();
        return period != null && account.getSignedOn() != null && Math.round((new Date().getTime() - account.getSignedOn().getTime()) / 86400000L) > period;
    }

    public static boolean isPasswordMathedRegExpression(String password) {
        List<String> regExpression = ((UsersModule)((Object)Roma.component(UsersModule.class))).getPasswordMatches();
        if (regExpression != null) {
            for (String curReg : regExpression) {
                if (curReg.equals("") || password.matches(curReg)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPasswordUnused(BaseAccount account, String password) {
        Integer passwordMaxNumber = ((UsersModule)((Object)Roma.component(UsersModule.class))).getPasswordMaxNumber();
        if (passwordMaxNumber != null) {
            List<String> oldPwd = account.getOldPasswords();
            if (oldPwd == null) {
                oldPwd = new ArrayList<String>();
                account.setOldPasswords(oldPwd);
            }
            if (oldPwd.contains(password)) {
                return false;
            }
            oldPwd.add(password);
            if (oldPwd.size() > passwordMaxNumber) {
                oldPwd.remove(0);
            }
        }
        return true;
    }
}

