/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.romaframework.aspect.authentication.AuthenticationAspect;
import org.romaframework.aspect.authentication.LoginListener;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.core.annotation.CoreClass;
import org.romaframework.aspect.persistence.annotation.Persistence;
import org.romaframework.aspect.session.SessionAccount;
import org.romaframework.aspect.validation.annotation.ValidationAction;
import org.romaframework.aspect.validation.annotation.ValidationField;
import org.romaframework.aspect.view.annotation.ViewAction;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.aspect.view.screen.Screen;
import org.romaframework.aspect.view.screen.config.ScreenManager;
import org.romaframework.core.Roma;
import org.romaframework.frontend.domain.message.Message;
import org.romaframework.frontend.domain.message.MessageResponseListener;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.listener.DefaultLoginListener;
import org.romaframework.module.users.view.domain.AccountManagementUtility;
import org.romaframework.module.users.view.domain.ChangePassword;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CoreClass(orderFields={"userName userPassword languages"})
public class Login
implements MessageResponseListener {
    public static final String PAR_FIRST_FORM_TO_DISPLAY = "_Login.firstFormToDisplay";
    @ValidationField(required=AnnotationConstants.TRUE)
    private String userName;
    @ValidationField(required=AnnotationConstants.TRUE)
    @ViewField(render="password")
    private String userPassword;
    @ViewField(render="select", selectionField="language")
    protected Set<String> languages = new HashSet<String>();
    protected AuthenticationAspect authManager = (AuthenticationAspect)Roma.component(AuthenticationAspect.class);
    private LoginListener listener;

    protected LoginListener getListener() {
        if (this.listener == null) {
            this.listener = new DefaultLoginListener();
        }
        return this.listener;
    }

    public Login(String iScreenName) {
        this();
        Screen screen = ((ScreenManager)Roma.component(ScreenManager.class)).getScreen(iScreenName);
        Roma.view().setScreen(screen);
    }

    public Login(String iUser, String iPassword) {
        this();
        this.userName = iUser;
        this.userPassword = iPassword;
        Roma.fieldChanged((Object)this, (String[])new String[]{"userName userPassword"});
    }

    public Login() {
        Set availableLocales = Roma.i18n().getAvailableLanguages();
        for (Locale l : availableLocales) {
            this.languages.add(l.getDisplayLanguage());
        }
    }

    protected void onSuccess() {
        this.getListener().onSuccess();
    }

    protected void onError() {
        this.onError(null);
    }

    protected void onError(Throwable t) {
        this.getListener().onError(t);
    }

    @ViewField(visible=AnnotationConstants.FALSE)
    public String getAlgorithm() {
        return "MD5";
    }

    @Persistence(mode="tx")
    @ValidationAction(validate=AnnotationConstants.TRUE)
    @ViewAction(submit=AnnotationConstants.TRUE, render="button")
    public void login() {
        if (this.userName == null || this.userName.length() == 0) {
            return;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("algorithm", this.getAlgorithm());
            BaseAccount account = (BaseAccount)this.authManager.authenticate(this.userName, this.userPassword, params);
            if (AccountManagementUtility.isPasswordExpired(account)) {
                this.showChangePassword();
            } else if (account != null && account.isChangePasswordNextLogin() != null && account.isChangePasswordNextLogin().booleanValue()) {
                this.showChangePassword();
            } else {
                this.onSuccess();
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    private void showChangePassword() {
        ChangePassword changePw = new ChangePassword((BaseAccount)this.authManager.getCurrentAccount(), this);
        changePw.setOldPassword(this.userPassword);
        Roma.flow().popup((Object)changePw);
    }

    public void responseMessage(Message iMessage, Object iResponse) {
        this.onSuccess();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    protected void setCurrentAccount(SessionAccount iAccount) {
        Roma.session().getActiveSessionInfo().setAccount(iAccount);
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    @ViewField(visible=AnnotationConstants.FALSE)
    public String getLanguage() {
        Locale l = Roma.session().getActiveLocale();
        if (l == null) {
            return null;
        }
        return l.getDisplayLanguage();
    }

    public void setLanguage(String iLanguage) {
        if (iLanguage == null) {
            return;
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!locale.getDisplayLanguage().equals(iLanguage)) continue;
            Roma.session().setActiveLocale(locale);
            Roma.fieldChanged((Object)this, (String[])new String[0]);
            break;
        }
    }

    public void setListener(LoginListener iListener) {
        this.listener = iListener;
    }
}

