/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain;

import org.romaframework.aspect.core.annotation.CoreClass;
import org.romaframework.aspect.flow.FlowAspect;
import org.romaframework.aspect.view.ViewCallback;
import org.romaframework.aspect.view.feature.ViewActionFeatures;
import org.romaframework.core.Roma;
import org.romaframework.core.flow.ObjectContext;
import org.romaframework.core.schema.Feature;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.portal.PortalPreferences;
import org.romaframework.module.users.domain.portal.PortalPreferencesHelper;
import org.romaframework.module.users.view.domain.ChangePassword;
import org.romaframework.module.users.view.domain.portal.PortletPreferencesConfiguration;

@CoreClass(orderFields={"userName account"}, orderActions={"changePassword changePreferences configurePortlets logout"})
public class UserInfo
implements ViewCallback {
    protected String userName;
    protected BaseAccount account;
    protected Object preferencesForm;
    protected ChangePassword changePasswordForm;
    protected PortletPreferencesConfiguration portletConfiguration;

    public UserInfo(Object iPreferencesForm) {
        this.preferencesForm = iPreferencesForm;
        this.account = (BaseAccount)Roma.session().getActiveSessionInfo().getAccount();
        if (this.account != null) {
            this.userName = this.account.toString();
            this.changePasswordForm = new ChangePassword(this.account, null);
            PortalPreferences preferences = PortalPreferencesHelper.getUserPreferences(this.account);
            this.portletConfiguration = preferences != null ? new PortletPreferencesConfiguration(preferences) : new PortletPreferencesConfiguration(new PortalPreferences(this.account));
        }
    }

    public void changePassword() {
        if (this.changePasswordForm != null) {
            ((FlowAspect)Roma.aspect(FlowAspect.class)).popup((Object)this.changePasswordForm);
        }
    }

    public void changePreferences() {
        if (this.preferencesForm != null) {
            ((FlowAspect)Roma.aspect(FlowAspect.class)).forward(this.preferencesForm);
        }
    }

    public void configurePortlets() {
        if (this.portletConfiguration != null) {
            ((FlowAspect)Roma.aspect(FlowAspect.class)).forward((Object)this.portletConfiguration);
        }
    }

    public void logout() {
        ObjectContext.getInstance().logout();
    }

    public void onDispose() {
    }

    public void onShow() {
        PortalPreferences preferences = PortalPreferencesHelper.getUserPreferences(this.account);
        if (preferences == null) {
            Roma.setFeature((Object)this, (String)"changePreferences", (Feature)ViewActionFeatures.ENABLED, (Object)Boolean.FALSE);
        }
    }
}

