/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain.baseaccount;

import java.util.ArrayList;
import java.util.List;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.core.annotation.CoreField;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.core.Roma;
import org.romaframework.core.repository.GenericRepository;
import org.romaframework.frontend.domain.crud.CRUDMain;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.repository.BaseAccountRepository;
import org.romaframework.module.users.view.domain.baseaccount.BaseAccountFilter;
import org.romaframework.module.users.view.domain.baseaccount.BaseAccountInstance;
import org.romaframework.module.users.view.domain.baseaccount.BaseAccountListable;
import org.romaframework.module.users.view.domain.basegroup.BaseGroupAssegnee;
import org.romaframework.module.users.view.domain.baseprofile.BaseProfileAssegnee;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAccountMain
extends CRUDMain<BaseAccount> {
    @CoreField(embedded=AnnotationConstants.TRUE)
    protected BaseAccountFilter filter;
    protected List<BaseAccountListable> result;

    public BaseAccountMain() {
        super(BaseAccountListable.class, BaseAccountInstance.class, BaseAccountInstance.class, BaseAccountInstance.class);
        if (Roma.existComponent(BaseAccountRepository.class)) {
            this.repository = (GenericRepository)Roma.component(BaseAccountRepository.class);
        }
        this.filter = new BaseAccountFilter();
        this.result = new ArrayList<BaseAccountListable>();
    }

    public BaseAccountFilter getFilter() {
        return this.filter;
    }

    public List<BaseAccountListable> getResult() {
        return this.result;
    }

    public void showAll() {
        QueryByFilter query = new QueryByFilter(BaseAccount.class);
        this.searchByFilter(query);
    }

    public void assignToProfile() {
        Object[] selection = this.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        Roma.flow().popup((Object)new BaseProfileAssegnee(this));
    }

    public void assignToGroup() {
        Object[] selection = this.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        Roma.flow().forward((Object)new BaseGroupAssegnee(this));
    }

    public void setResult(Object iValue) {
        this.result = (List)iValue;
    }
}

