/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain.baseprofile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.core.annotation.CoreClass;
import org.romaframework.aspect.reporting.annotation.ReportingField;
import org.romaframework.aspect.session.SessionInfo;
import org.romaframework.aspect.validation.CustomValidation;
import org.romaframework.aspect.validation.ValidationException;
import org.romaframework.aspect.view.SelectionMode;
import org.romaframework.aspect.view.ViewCallback;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.core.Roma;
import org.romaframework.core.schema.SchemaAction;
import org.romaframework.core.schema.SchemaClass;
import org.romaframework.core.schema.SchemaField;
import org.romaframework.core.schema.SchemaManager;
import org.romaframework.frontend.domain.crud.CRUDInstance;
import org.romaframework.module.users.domain.BaseFunction;
import org.romaframework.module.users.domain.BaseProfile;
import org.romaframework.module.users.view.domain.basefunction.BaseFunctionListable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CoreClass(orderFields={"entity availableClassNames availableMembers functions"})
public class BaseProfileInstance
extends CRUDInstance<BaseProfile>
implements CustomValidation,
ViewCallback {
    private static final String DEF_HOME_PAGE = "HomePage";
    private static final String CLASS_ELEMENT = "< Class >";
    @ViewField(selectionField="selectedAvailableClassName", enabled=AnnotationConstants.FALSE)
    @ReportingField(visible=AnnotationConstants.FALSE)
    protected ArrayList<String> availableClassNames;
    @ViewField(selectionField="selectedAvailableMember", enabled=AnnotationConstants.FALSE)
    protected ArrayList<String> availableMembers;
    @ViewField(visible=AnnotationConstants.FALSE)
    protected String selectedAvailableMember;
    protected SchemaClass selectedAvailableClass;
    @ViewField(visible=AnnotationConstants.FALSE)
    protected BaseFunction selectedFunction;
    @ViewField(selectionField="selectedFunction", enabled=AnnotationConstants.FALSE, render="tableedit")
    protected List<BaseFunctionListable> functions = new ArrayList<BaseFunctionListable>();

    @ViewField(label="Mode", render="select", selectionField="entity.mode", selectionMode=SelectionMode.SELECTION_MODE_INDEX)
    @ReportingField(visible=AnnotationConstants.FALSE)
    public BaseProfile.Mode[] getModes() {
        return BaseProfile.Mode.values();
    }

    public List<BaseFunctionListable> getFunctions() {
        this.functions.clear();
        for (BaseFunction f : ((BaseProfile)this.entity).getFunctions().values()) {
            this.functions.add(new BaseFunctionListable(f));
        }
        return this.functions;
    }

    public void onCreate() {
        BaseProfile newProfile = new BaseProfile();
        this.setEntity(newProfile);
        ((BaseProfile)this.getEntity()).setMode(BaseProfile.Mode.ALLOW_ALL_BUT);
        ((BaseProfile)this.getEntity()).setFunctions(new TreeMap<String, BaseFunction>());
        ((BaseProfile)this.getEntity()).setHomePage(DEF_HOME_PAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Collection activeSessions;
        boolean found = false;
        block3: while (!found) {
            found = true;
            if (((BaseProfile)this.getEntity()).getFunctions() == null) continue;
            for (Map.Entry<String, BaseFunction> fun : ((BaseProfile)this.getEntity()).getFunctions().entrySet()) {
                String key = fun.getKey();
                if (((BaseProfile)this.getEntity()).getFunctions().get(key).getName().equals(key)) continue;
                ((BaseProfile)this.getEntity()).getFunctions().put(fun.getValue().getName(), fun.getValue());
                ((BaseProfile)this.getEntity()).getFunctions().remove(key);
                found = false;
                continue block3;
            }
        }
        super.save();
        Collection collection = activeSessions = Roma.session().getSessionInfos();
        synchronized (collection) {
            for (SessionInfo s : activeSessions) {
                if (s.getAccount() == null || !s.getAccount().getProfile().equals(this.getEntity())) continue;
                s.getAccount().setProfile(this.getEntity());
            }
        }
    }

    public void onShow() {
        SchemaManager schemaMgr = Roma.schema();
        Collection infos = schemaMgr.getAllClassesInfo();
        this.availableClassNames = new ArrayList();
        for (SchemaClass cls : infos) {
            this.availableClassNames.add(cls.getName());
        }
        Collections.sort(this.availableClassNames);
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"availableClassNames"});
    }

    public void setSelectedAvailableClassName(String iSelection) {
        this.availableMembers = new ArrayList();
        this.selectedAvailableClass = Roma.schema().getSchemaClass(iSelection);
        this.availableMembers.add(CLASS_ELEMENT);
        Iterator it = this.selectedAvailableClass.getActionIterator();
        while (it.hasNext()) {
            this.availableMembers.add(((SchemaAction)it.next()).getName() + "()");
        }
        it = this.selectedAvailableClass.getFieldIterator();
        while (it.hasNext()) {
            this.availableMembers.add(((SchemaField)it.next()).getName());
        }
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"availableMembers"});
    }

    public void add() {
        if (this.availableMembers == null) {
            return;
        }
        String funcName = this.selectedAvailableClass.getName();
        if (!this.selectedAvailableMember.equals(CLASS_ELEMENT) && (funcName = funcName + "." + this.selectedAvailableMember).endsWith("()")) {
            funcName = funcName.substring(0, funcName.length() - 2);
        }
        boolean allowFunction = ((BaseProfile)this.getEntity()).getMode() == null || ((BaseProfile)this.getEntity()).getMode() == BaseProfile.Mode.DENY_ALL_BUT;
        ((BaseProfile)this.getEntity()).addFunction(funcName, allowFunction);
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"functions"});
    }

    public void remove() {
        if (this.selectedFunction == null) {
            return;
        }
        ((BaseProfile)this.getEntity()).removeFunction(this.selectedFunction.getName());
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"functions"});
    }

    @ViewField(visible=AnnotationConstants.FALSE)
    public String getSelectedAvailableClassName() {
        if (this.selectedAvailableClass != null) {
            return this.selectedAvailableClass.getName();
        }
        return null;
    }

    public ArrayList<String> getAvailableMembers() {
        return this.availableMembers;
    }

    public void setAvailableMembers(ArrayList<String> availableMembers) {
        this.availableMembers = availableMembers;
    }

    public String getSelectedAvailableMember() {
        return this.selectedAvailableMember;
    }

    public void setSelectedAvailableMember(String selectedAvailableMember) {
        this.selectedAvailableMember = selectedAvailableMember;
    }

    public void validate() throws ValidationException {
    }

    public ArrayList<String> getAvailableClassNames() {
        return this.availableClassNames;
    }

    public void setAvailableClassNames(ArrayList<String> availableClassNames) {
        this.availableClassNames = availableClassNames;
    }

    public BaseFunction getSelectedFunction() {
        return this.selectedFunction;
    }

    public void setSelectedFunction(BaseFunction selectedFunction) {
        this.selectedFunction = selectedFunction;
    }
}

