/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain.customprofiling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.i18n.I18NType;
import org.romaframework.aspect.view.ViewCallback;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.aspect.view.feature.ViewClassFeatures;
import org.romaframework.aspect.view.feature.ViewElementFeatures;
import org.romaframework.core.Roma;
import org.romaframework.core.config.Refreshable;
import org.romaframework.core.schema.SchemaClassDefinition;
import org.romaframework.core.schema.SchemaClassElement;
import org.romaframework.core.schema.SchemaFeatures;
import org.romaframework.core.schema.SchemaField;
import org.romaframework.module.users.CustomProfiler;
import org.romaframework.module.users.domain.CustomFunction;
import org.romaframework.module.users.domain.CustomProfiling;
import org.romaframework.module.users.view.domain.customprofiling.CustomFunctionListable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProfilingSettings
implements ViewCallback {
    private SchemaClassDefinition classDefinition;
    private boolean actions;
    private boolean fields;
    @ViewField(label="", enabled=AnnotationConstants.FALSE)
    private List<CustomFunctionListable> enabledFunctions;
    private CustomProfiling profiling;
    private Map<String, String> labelAssoc = new HashMap<String, String>();

    public CustomProfilingSettings(SchemaClassDefinition schemaClass) {
        this(schemaClass, new HashMap<String, String>());
    }

    public CustomProfilingSettings(SchemaClassDefinition schemaClass, Map<String, String> labelAssoc) {
        this(schemaClass, true, true);
        this.labelAssoc = labelAssoc;
    }

    public CustomProfilingSettings(SchemaClassDefinition schemaClass, boolean actions, boolean fields) {
        this.classDefinition = schemaClass;
        this.actions = actions;
        this.fields = fields;
    }

    public void onDispose() {
    }

    public void onShow() {
        this.profiling = ((CustomProfiler)Roma.component(CustomProfiler.class)).getCustomProfiling();
        if (this.profiling == null) {
            this.profiling = ((CustomProfiler)Roma.component(CustomProfiler.class)).createCustomProfiling();
        }
        if (this.enabledFunctions == null) {
            this.enabledFunctions = new ArrayList<CustomFunctionListable>();
            this.addSchemaClass(this.classDefinition);
            Roma.fieldChanged((Object)this, (String[])new String[]{"enabledFunctions"});
        }
    }

    private void addSchemaClass(SchemaClassDefinition schemaClass) {
        if (this.fields) {
            Iterator fieldItarator = schemaClass.getFieldIterator();
            while (fieldItarator.hasNext()) {
                this.addListable((SchemaClassElement)fieldItarator.next());
            }
        }
        if (this.actions) {
            Iterator actionItarator = schemaClass.getActionIterator();
            while (actionItarator.hasNext()) {
                this.addListable((SchemaClassElement)actionItarator.next());
            }
        }
    }

    private void addListable(SchemaClassElement element) {
        if (((Boolean)element.getFeature(ViewElementFeatures.VISIBLE)).booleanValue()) {
            String layout = (String)element.getFeature(ViewElementFeatures.LAYOUT);
            if (layout != null && "expand".equals(layout)) {
                if (element instanceof SchemaField) {
                    this.addSchemaClass(((SchemaField)element).getType());
                }
            } else {
                String label = this.labelAssoc.get(element.getName()) != null ? this.labelAssoc.get(element.getName()) : Roma.i18n().get((SchemaFeatures)element, I18NType.LABEL, ViewClassFeatures.LABEL, new Object[0]);
                String functionName = element.getEntity().getName() + "." + element.getName();
                CustomFunction function = this.profiling.getFunctions().get(functionName);
                if (function == null) {
                    function = new CustomFunction(functionName, true);
                }
                this.enabledFunctions.add(new CustomFunctionListable(label, function));
            }
        }
    }

    public void cancel() {
        Roma.flow().back();
    }

    public void save() {
        for (CustomFunctionListable listable : this.enabledFunctions) {
            CustomFunction function = (CustomFunction)listable.getEntity();
            if (function.isAllow().booleanValue()) continue;
            this.profiling.getFunctions().put(function.getName(), function);
        }
        this.profiling = (CustomProfiling)Roma.repository(CustomProfiling.class).update((Object)this.profiling, (byte)2);
        ((CustomProfiler)Roma.component(CustomProfiler.class)).setCustomProfiling(this.profiling);
        Object back = Roma.flow().back();
        if (back instanceof Refreshable) {
            ((Refreshable)back).refresh();
        }
    }

    public void all() {
        for (CustomFunctionListable cur : this.enabledFunctions) {
            ((CustomFunction)cur.getEntity()).setAllow(true);
        }
        Roma.fieldChanged((Object)this, (String[])new String[]{"enabledFunctions"});
    }

    public void none() {
        for (CustomFunctionListable cur : this.enabledFunctions) {
            ((CustomFunction)cur.getEntity()).setAllow(false);
        }
        Roma.fieldChanged((Object)this, (String[])new String[]{"enabledFunctions"});
    }

    @ViewField(render="tableedit")
    public List<CustomFunctionListable> getEnabledFunctions() {
        return this.enabledFunctions;
    }

    public void setEnabledFunctions(List<CustomFunctionListable> enabledFunctions) {
        this.enabledFunctions = enabledFunctions;
    }
}

