/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.sle.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.sle.SimpleListExtension;
import com.sun.syndication.feed.module.sle.SimpleListExtensionImpl;
import com.sun.syndication.feed.module.sle.types.Group;
import com.sun.syndication.feed.module.sle.types.Sort;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class ModuleParser
implements com.sun.syndication.io.ModuleParser {
    static final Namespace NS = Namespace.getNamespace((String)"cf", (String)"http://www.microsoft.com/schemas/rss/core/2005");
    public static final Namespace TEMP = Namespace.getNamespace((String)"rome-sle", (String)"urn:rome:sle");

    public String getNamespaceUri() {
        return "http://www.microsoft.com/schemas/rss/core/2005";
    }

    public Module parse(Element element) {
        if (element.getChild("treatAs", NS) == null) {
            return null;
        }
        SimpleListExtensionImpl sle = new SimpleListExtensionImpl();
        sle.setTreatAs(element.getChildText("treatAs", NS));
        Element listInfo = element.getChild("listinfo", NS);
        List groups = listInfo.getChildren("group", NS);
        ArrayList<Cloneable> values = new ArrayList<Cloneable>();
        for (int i = 0; groups != null && i < groups.size(); ++i) {
            Element ge = (Element)groups.get(i);
            Namespace ns = ge.getAttribute("ns") == null ? element.getNamespace() : Namespace.getNamespace((String)ge.getAttributeValue("ns"));
            String elementName = ge.getAttributeValue("element");
            String label = ge.getAttributeValue("label");
            values.add(new Group(ns, elementName, label));
        }
        sle.setGroupFields(values.toArray(new Group[values.size()]));
        values = values.size() == 0 ? values : new ArrayList<Cloneable>();
        List sorts = listInfo.getChildren("sort", NS);
        for (int i = 0; sorts != null && i < sorts.size(); ++i) {
            Element se = (Element)sorts.get(i);
            System.out.println("Parse cf:sort " + se.getAttributeValue("element") + se.getAttributeValue("data-type"));
            Namespace ns = se.getAttributeValue("ns") == null ? element.getNamespace() : Namespace.getNamespace((String)se.getAttributeValue("ns"));
            String elementName = se.getAttributeValue("element");
            String label = se.getAttributeValue("label");
            String dataType = se.getAttributeValue("data-type");
            boolean defaultOrder = se.getAttributeValue("default") == null ? false : new Boolean(se.getAttributeValue("default"));
            values.add(new Sort(ns, elementName, dataType, label, defaultOrder));
        }
        sle.setSortFields(values.toArray(new Sort[values.size()]));
        this.insertValues(sle, element.getChildren());
        return sle;
    }

    protected void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    public void insertValues(SimpleListExtension sle, List elements) {
        for (int i = 0; elements != null && i < elements.size(); ++i) {
            Element e = (Element)elements.get(i);
            Group[] groups = sle.getGroupFields();
            for (int g = 0; g < groups.length; ++g) {
                Element value = e.getChild(groups[g].getElement(), groups[g].getNamespace());
                if (value == null) continue;
                Element group = new Element("group", TEMP);
                this.addNotNullAttribute(group, "element", groups[g].getElement());
                this.addNotNullAttribute(group, "label", groups[g].getLabel());
                this.addNotNullAttribute(group, "value", value.getText());
                this.addNotNullAttribute(group, "ns", groups[g].getNamespace().getURI());
                e.addContent((Content)group);
            }
            Sort[] sorts = sle.getSortFields();
            for (int s = 0; s < sorts.length; ++s) {
                System.out.println("Inserting for " + sorts[s].getElement() + " " + sorts[s].getDataType());
                Element sort = new Element("sort", TEMP);
                if (sorts[s].getDefaultOrder()) {
                    sort.setAttribute("label", sorts[s].getLabel());
                    sort.setAttribute("value", Integer.toString(i));
                    sort.setAttribute("data-type", "number");
                    e.addContent((Content)sort);
                    continue;
                }
                Element value = e.getChild(sorts[s].getElement(), sorts[s].getNamespace());
                if (value == null) {
                    System.out.println("No value for " + sorts[s].getElement() + " : " + sorts[s].getNamespace());
                } else {
                    System.out.println(sorts[s].getElement() + " value: " + value.getText());
                }
                if (value == null) continue;
                this.addNotNullAttribute(sort, "label", sorts[s].getLabel());
                this.addNotNullAttribute(sort, "element", sorts[s].getElement());
                this.addNotNullAttribute(sort, "value", value.getText());
                this.addNotNullAttribute(sort, "data-type", sorts[s].getDataType());
                this.addNotNullAttribute(sort, "ns", sorts[s].getNamespace().getURI());
                e.addContent((Content)sort);
                System.out.println("Added " + sort + " " + sorts[s].getLabel() + " = " + value.getText());
            }
        }
    }
}

