/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jtslab.SnapRoundFunctions;

public class SnapRoundOverlayFunctions {
    public static Geometry intersection(Geometry geomA, Geometry geomB, double scaleFactor) {
        Geometry[] geom = SnapRoundOverlayFunctions.snapClean(geomA, geomB, scaleFactor);
        return geom[0].intersection(geom[1]);
    }

    public static Geometry difference(Geometry geomA, Geometry geomB, double scaleFactor) {
        Geometry[] geom = SnapRoundOverlayFunctions.snapClean(geomA, geomB, scaleFactor);
        return geom[0].difference(geom[1]);
    }

    public static Geometry symDifference(Geometry geomA, Geometry geomB, double scaleFactor) {
        Geometry[] geom = SnapRoundOverlayFunctions.snapClean(geomA, geomB, scaleFactor);
        return geom[0].symDifference(geom[1]);
    }

    public static Geometry union(Geometry geomA, Geometry geomB, double scaleFactor) {
        Geometry[] geom = SnapRoundOverlayFunctions.snapClean(geomA, geomB, scaleFactor);
        return geom[0].union(geom[1]);
    }

    public static Geometry unaryUnion(Geometry geomA, double scaleFactor) {
        Geometry[] geom = SnapRoundOverlayFunctions.snapClean(geomA, null, scaleFactor);
        return geom[0].union();
    }

    private static Geometry[] snapClean(Geometry geomA, Geometry geomB, double scaleFactor) {
        Geometry snapped;
        Geometry aSnap = snapped = SnapRoundFunctions.snapRound(geomA, geomB, scaleFactor);
        Geometry bSnap = null;
        if (geomB != null) {
            aSnap = snapped.getGeometryN(0);
            bSnap = snapped.getGeometryN(1);
        }
        return new Geometry[]{aSnap, bSnap};
    }

    private static Geometry clean(Geometry geom) {
        if (!(geom instanceof Polygonal)) {
            return geom;
        }
        return geom.buffer(0.0);
    }
}

