/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.clean;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.GeometryMapper;

public class InvalidHoleRemover {
    private Geometry geom;

    public static Geometry clean(Geometry geom) {
        InvalidHoleRemover pihr = new InvalidHoleRemover(geom);
        return pihr.getResult();
    }

    public InvalidHoleRemover(Geometry geom) {
        this.geom = geom;
    }

    public Geometry getResult() {
        return GeometryMapper.map((Geometry)this.geom, (GeometryMapper.MapOp)new InvalidHoleRemoverMapOp());
    }

    private static class PolygonInvalidHoleRemover {
        private Polygon poly;

        public static Polygon clean(Polygon poly) {
            PolygonInvalidHoleRemover pihr = new PolygonInvalidHoleRemover(poly);
            return pihr.getResult();
        }

        public PolygonInvalidHoleRemover(Polygon poly) {
            this.poly = poly;
        }

        public Polygon getResult() {
            GeometryFactory gf = this.poly.getFactory();
            Polygon shell = gf.createPolygon((LinearRing)this.poly.getExteriorRing());
            PreparedGeometry shellPrep = PreparedGeometryFactory.prepare((Geometry)shell);
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 0; i < this.poly.getNumInteriorRing(); ++i) {
                LinearRing hole = (LinearRing)this.poly.getInteriorRingN(i);
                if (!shellPrep.covers((Geometry)hole)) continue;
                holes.add(hole);
            }
            if (holes.size() == this.poly.getNumInteriorRing()) {
                return this.poly;
            }
            Polygon result = gf.createPolygon((LinearRing)this.poly.getExteriorRing(), GeometryFactory.toLinearRingArray(holes));
            return result;
        }
    }

    private static class InvalidHoleRemoverMapOp
    implements GeometryMapper.MapOp {
        private InvalidHoleRemoverMapOp() {
        }

        public Geometry map(Geometry geom) {
            if (geom instanceof Polygon) {
                return PolygonInvalidHoleRemover.clean((Polygon)geom);
            }
            return geom;
        }
    }
}

