/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.clean;

import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jtslab.clean.HoleRemover;

public class SmallHoleRemover {
    public static Geometry clean(Geometry geom, double areaTolerance) {
        HoleRemover remover = new HoleRemover(geom, new IsSmall(areaTolerance));
        return remover.getResult();
    }

    private static class IsSmall
    implements HoleRemover.Predicate {
        private double area;

        public IsSmall(double area) {
            this.area = area;
        }

        @Override
        public boolean value(Geometry geom) {
            double holeArea = Area.ofRing((Coordinate[])geom.getCoordinates());
            return holeArea <= this.area;
        }
    }
}

