/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.geom.util;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class GeometryEditorEx {
    private GeometryFactory targetFactory = null;
    private boolean isUserDataCopied = false;
    private GeometryEditorOperation operation;

    public GeometryEditorEx() {
        this(new NoOpGeometryOperation());
    }

    public GeometryEditorEx(GeometryFactory targetFactory) {
        this(new NoOpGeometryOperation(), targetFactory);
    }

    public GeometryEditorEx(GeometryEditorOperation operation) {
        this.operation = operation;
    }

    public GeometryEditorEx(GeometryEditorOperation operation, GeometryFactory targetFactory) {
        this.operation = operation;
        this.targetFactory = targetFactory;
    }

    public void setCopyUserData(boolean isUserDataCopied) {
        this.isUserDataCopied = isUserDataCopied;
    }

    public Geometry edit(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        Geometry result = this.editInternal(geometry);
        if (this.isUserDataCopied) {
            result.setUserData(geometry.getUserData());
        }
        return result;
    }

    private Geometry editInternal(Geometry geometry) {
        if (this.targetFactory == null) {
            this.targetFactory = geometry.getFactory();
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry);
        }
        if (geometry instanceof Point) {
            return this.editPoint((Point)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.editLinearRing((LinearRing)geometry);
        }
        if (geometry instanceof LineString) {
            return this.editLineString((LineString)geometry);
        }
        Assert.shouldNeverReachHere((String)("Unsupported Geometry class: " + geometry.getClass().getName()));
        return null;
    }

    private Point editPoint(Point geom) {
        Point newGeom = (Point)this.operation.edit((Geometry)geom, this.targetFactory);
        if (newGeom == null) {
            newGeom = this.targetFactory.createPoint((CoordinateSequence)null);
        } else if (newGeom == geom) {
            newGeom = (Point)this.targetFactory.createGeometry((Geometry)geom);
        }
        return newGeom;
    }

    private LineString editLineString(LineString geom) {
        LineString newGeom = (LineString)this.operation.edit((Geometry)geom, this.targetFactory);
        if (newGeom == null) {
            newGeom = this.targetFactory.createLineString((CoordinateSequence)null);
        } else if (newGeom == geom) {
            newGeom = (LineString)this.targetFactory.createGeometry((Geometry)geom);
        }
        return newGeom;
    }

    private LinearRing editLinearRing(LinearRing geom) {
        LinearRing newGeom = (LinearRing)this.operation.edit((Geometry)geom, this.targetFactory);
        if (newGeom == null) {
            newGeom = this.targetFactory.createLinearRing((CoordinateSequence)null);
        } else if (newGeom == geom) {
            newGeom = (LinearRing)this.targetFactory.createGeometry((Geometry)geom);
        }
        return newGeom;
    }

    private Polygon editPolygon(Polygon polygon) {
        Polygon newPolygon = (Polygon)this.operation.edit((Geometry)polygon, this.targetFactory);
        if (newPolygon == null) {
            newPolygon = this.targetFactory.createPolygon((CoordinateSequence)null);
            return newPolygon;
        }
        if (newPolygon != polygon) {
            return newPolygon;
        }
        LinearRing shell = (LinearRing)this.edit((Geometry)newPolygon.getExteriorRing());
        if (shell == null || shell.isEmpty()) {
            return this.targetFactory.createPolygon(null, null);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < newPolygon.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)this.edit((Geometry)newPolygon.getInteriorRingN(i));
            if (hole == null || hole.isEmpty()) continue;
            holes.add(hole);
        }
        return this.targetFactory.createPolygon(shell, holes.toArray(new LinearRing[0]));
    }

    private GeometryCollection editGeometryCollection(GeometryCollection collection) {
        GeometryCollection collectionForType = (GeometryCollection)this.operation.edit((Geometry)collection, this.targetFactory);
        if (collectionForType != collection) {
            return collectionForType;
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < collectionForType.getNumGeometries(); ++i) {
            Geometry geometry = this.edit(collectionForType.getGeometryN(i));
            if (geometry == null || geometry.isEmpty()) continue;
            geometries.add(geometry);
        }
        if (collectionForType.getClass() == MultiPoint.class) {
            return this.targetFactory.createMultiPoint(geometries.toArray(new Point[0]));
        }
        if (collectionForType.getClass() == MultiLineString.class) {
            return this.targetFactory.createMultiLineString(geometries.toArray(new LineString[0]));
        }
        if (collectionForType.getClass() == MultiPolygon.class) {
            return this.targetFactory.createMultiPolygon(geometries.toArray(new Polygon[0]));
        }
        return this.targetFactory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public static abstract class CoordinateSequenceOperation
    implements GeometryEditorOperation {
        @Override
        public final Geometry edit(Geometry geometry, GeometryFactory targetFactory) {
            if (geometry instanceof LinearRing) {
                return targetFactory.createLinearRing(this.edit(((LinearRing)geometry).getCoordinateSequence(), geometry, targetFactory));
            }
            if (geometry instanceof LineString) {
                return targetFactory.createLineString(this.edit(((LineString)geometry).getCoordinateSequence(), geometry, targetFactory));
            }
            if (geometry instanceof Point) {
                return targetFactory.createPoint(this.edit(((Point)geometry).getCoordinateSequence(), geometry, targetFactory));
            }
            return geometry;
        }

        public abstract CoordinateSequence edit(CoordinateSequence var1, Geometry var2, GeometryFactory var3);
    }

    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        @Override
        public final Geometry edit(Geometry geometry, GeometryFactory targetFactory) {
            if (geometry instanceof LinearRing) {
                return targetFactory.createLinearRing(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof LineString) {
                return targetFactory.createLineString(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof Point) {
                Coordinate[] newCoordinates = this.edit(geometry.getCoordinates(), geometry);
                return targetFactory.createPoint(newCoordinates.length > 0 ? newCoordinates[0] : null);
            }
            return geometry;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, Geometry var2);
    }

    public static class NoOpGeometryOperation
    implements GeometryEditorOperation {
        @Override
        public Geometry edit(Geometry geometry, GeometryFactory targetFactory) {
            return geometry;
        }
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1, GeometryFactory var2);
    }
}

