/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.snapround;

import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jtslab.geom.util.GeometryEditorEx;

class GeometryCoordinateReplacer
extends GeometryEditorEx.CoordinateSequenceOperation {
    private Map geometryLinesMap;

    public GeometryCoordinateReplacer(Map linesMap) {
        this.geometryLinesMap = linesMap;
    }

    @Override
    public CoordinateSequence edit(CoordinateSequence coordSeq, Geometry geometry, GeometryFactory targetFactory) {
        if (this.geometryLinesMap.containsKey(geometry)) {
            Coordinate[] pts = (Coordinate[])this.geometryLinesMap.get(geometry);
            boolean isValidPts = GeometryCoordinateReplacer.isValidSize(pts, geometry);
            if (!isValidPts) {
                return null;
            }
            return targetFactory.getCoordinateSequenceFactory().create(pts);
        }
        return coordSeq;
    }

    private static boolean isValidSize(Coordinate[] pts, Geometry geom) {
        if (pts.length == 0) {
            return true;
        }
        int minSize = GeometryCoordinateReplacer.minimumNonEmptyCoordinatesSize(geom);
        return pts.length >= minSize;
    }

    private static int minimumNonEmptyCoordinatesSize(Geometry geom) {
        if (geom instanceof LinearRing) {
            return 4;
        }
        if (geom instanceof LineString) {
            return 2;
        }
        return 0;
    }
}

