/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.snapround;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.snapround.MCIndexSnapRounder;
import org.locationtech.jtslab.geom.util.GeometryEditorEx;
import org.locationtech.jtslab.snapround.GeometryCoordinateReplacer;
import org.locationtech.jtslab.snapround.PolygonCleaner;

public class GeometrySnapRounder {
    private PrecisionModel pm;
    private boolean isLineworkOnly = false;

    public GeometrySnapRounder(PrecisionModel pm) {
        this.pm = pm;
    }

    public void setLineworkOnly(boolean isLineworkOnly) {
        this.isLineworkOnly = isLineworkOnly;
    }

    public Geometry execute(Geometry geom) {
        List segStrings = GeometrySnapRounder.extractTaggedSegmentStrings(geom, this.pm);
        this.snapRound(segStrings);
        if (this.isLineworkOnly) {
            return this.toNodedLines(segStrings, geom.getFactory());
        }
        Geometry geomSnapped = this.replaceLines(geom, segStrings);
        Geometry geomClean = GeometrySnapRounder.ensureValid(geomSnapped);
        return geomClean;
    }

    private Geometry toNodedLines(Collection segStrings, GeometryFactory geomFact) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (NodedSegmentString nss : segStrings) {
            if (nss.size() < 2) continue;
            Coordinate[] pts = nss.getNodeList().getSplitCoordinates();
            lines.add(geomFact.createLineString(pts));
        }
        return geomFact.buildGeometry(lines);
    }

    private Geometry replaceLines(Geometry geom, List segStrings) {
        HashMap nodedLinesMap = this.nodedLinesMap(segStrings);
        GeometryCoordinateReplacer lineReplacer = new GeometryCoordinateReplacer(nodedLinesMap);
        GeometryEditorEx geomEditor = new GeometryEditorEx(lineReplacer);
        Geometry snapped = geomEditor.edit(geom);
        return snapped;
    }

    private void snapRound(List segStrings) {
        MCIndexSnapRounder sr = new MCIndexSnapRounder(this.pm);
        sr.computeNodes((Collection)segStrings);
    }

    private HashMap nodedLinesMap(Collection segStrings) {
        HashMap<Object, Coordinate[]> ptsMap = new HashMap<Object, Coordinate[]>();
        for (NodedSegmentString nss : segStrings) {
            if (nss.size() < 2) continue;
            Coordinate[] pts = nss.getNodeList().getSplitCoordinates();
            ptsMap.put(nss.getData(), pts);
        }
        return ptsMap;
    }

    static List extractTaggedSegmentStrings(Geometry geom, final PrecisionModel pm) {
        final ArrayList segStrings = new ArrayList();
        GeometryComponentFilter filter = new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                if (!(geom instanceof LineString)) {
                    return;
                }
                if (geom.getNumPoints() <= 0) {
                    return;
                }
                Coordinate[] roundPts = GeometrySnapRounder.round(((LineString)geom).getCoordinateSequence(), pm);
                segStrings.add(new NodedSegmentString(roundPts, (Object)geom));
            }
        };
        geom.apply(filter);
        return segStrings;
    }

    static Coordinate[] round(CoordinateSequence seq, PrecisionModel pm) {
        if (seq.size() == 0) {
            return new Coordinate[0];
        }
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < seq.size(); ++i) {
            Coordinate coord = new Coordinate(seq.getOrdinate(i, 0), seq.getOrdinate(i, 1));
            pm.makePrecise(coord);
            coordList.add(coord, false);
        }
        Coordinate[] coord = coordList.toCoordinateArray();
        return coord;
    }

    private static Geometry ensureValid(Geometry geom) {
        if (geom.isValid()) {
            return geom;
        }
        return GeometrySnapRounder.cleanPolygonal(geom);
    }

    private static Geometry cleanPolygonal(Geometry geom) {
        return PolygonCleaner.clean(geom);
    }
}

