/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.snapround;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class PolygonCleaner {
    public static Geometry clean(Geometry geom) {
        PolygonCleanerTransformer trans = new PolygonCleanerTransformer();
        return trans.transform(geom);
    }

    static class PolygonCleanerTransformer
    extends GeometryTransformer {
        PolygonCleanerTransformer() {
        }

        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            if (parent instanceof MultiPolygon) {
                return geom;
            }
            return this.createValidArea((Geometry)geom);
        }

        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry roughGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(roughGeom);
        }

        private Geometry createValidArea(Geometry area) {
            if (area.isValid()) {
                return area;
            }
            return area.buffer(0.0);
        }
    }
}

