/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.api;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathSelector;
import org.rundeck.storage.api.ResourceSelector;

public class PathUtil {
    public static final String SEPARATOR = "/";
    public static final Path ROOT = PathUtil.asPath("/");

    public static Path asPath(String path) {
        if (null == path) {
            return null;
        }
        return new PathImpl(PathUtil.cleanPath(path));
    }

    public static Path pathFromComponents(String[] components) {
        if (null == components || components.length == 0) {
            return null;
        }
        return new PathImpl(PathUtil.pathStringFromComponents(components));
    }

    public static String pathStringFromComponents(String[] components) {
        if (null == components || components.length == 0) {
            return null;
        }
        return PathUtil.cleanPath(PathUtil.join(components, SEPARATOR));
    }

    private static String join(String[] components, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String component : components) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(component);
        }
        return sb.toString();
    }

    public static boolean hasRoot(Path path, Path root) {
        return PathUtil.hasRoot(path.getPath(), root.getPath());
    }

    public static boolean hasRoot(String path, String root) {
        String r;
        String p = PathUtil.cleanPath(path);
        return p.equals(r = PathUtil.cleanPath(root)) || r.equals(PathUtil.cleanPath(ROOT.getPath())) || p.startsWith(r + SEPARATOR);
    }

    public static Path parentPath(Path path) {
        return PathUtil.asPath(PathUtil.parentPathString(path.getPath()));
    }

    public static boolean isRoot(String path) {
        return PathUtil.isRoot(PathUtil.asPath(path));
    }

    public static boolean isRoot(Path path) {
        return path.equals(ROOT);
    }

    public static String parentPathString(String path) {
        String[] split = PathUtil.cleanPath(path).split(SEPARATOR);
        if (split.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < split.length - 1; ++i) {
                if (i > 0) {
                    stringBuilder.append(SEPARATOR);
                }
                stringBuilder.append(split[i]);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String cleanPath(String path) {
        if (path.endsWith(SEPARATOR)) {
            path = path.replaceAll("/+$", "");
        }
        if (path.startsWith(SEPARATOR)) {
            path = path.replaceAll("^/+", "");
        }
        return path.replaceAll("/+", SEPARATOR);
    }

    public static String pathName(String path) {
        String[] split = PathUtil.cleanPath(path).split(SEPARATOR);
        if (split.length > 0) {
            return split[split.length - 1];
        }
        return null;
    }

    public static String removePrefix(String rootPath, String extpath) {
        if (!PathUtil.hasRoot(extpath, rootPath)) {
            return extpath;
        }
        return PathUtil.cleanPath(PathUtil.cleanPath(extpath).substring(PathUtil.cleanPath(rootPath).length()));
    }

    public static Path appendPath(Path prefix, String subpath) {
        return PathUtil.asPath(PathUtil.appendPath(prefix.getPath(), subpath));
    }

    public static String appendPath(String prefixPath, String subpath) {
        return PathUtil.cleanPath(prefixPath) + SEPARATOR + PathUtil.cleanPath(subpath);
    }

    public static PathSelector subpathSelector(final Path rootPath) {
        return new PathSelector(){

            @Override
            public boolean matchesPath(Path path) {
                return path.equals(rootPath) || PathUtil.hasRoot(path, rootPath);
            }
        };
    }

    public static PathSelector allpathSelector() {
        return new PathSelector(){

            @Override
            public boolean matchesPath(Path path) {
                return true;
            }
        };
    }

    public static <T extends ContentMeta> ResourceSelector<T> exactMetadataResourceSelector(final Map<String, String> required, final boolean requireAll) {
        return new ResourceSelector<T>(){

            @Override
            public boolean matchesContent(T content) {
                for (String key : required.keySet()) {
                    String expect = (String)required.get(key);
                    String test = content.getMeta().get(key);
                    if (null != test && expect.equals(test)) {
                        if (requireAll) continue;
                        return true;
                    }
                    if (!requireAll) continue;
                    return false;
                }
                return requireAll;
            }
        };
    }

    public static <T extends ContentMeta> ResourceSelector<T> regexMetadataResourceSelector(final Map<String, String> required, final boolean requireAll) {
        return new ResourceSelector<T>(){
            Map<String, Pattern> patternMap = new HashMap<String, Pattern>();

            private Pattern forString(String regex) {
                if (null == this.patternMap.get(regex)) {
                    Pattern compile = null;
                    try {
                        compile = Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException ignored) {
                        return null;
                    }
                    this.patternMap.put(regex, compile);
                }
                return this.patternMap.get(regex);
            }

            @Override
            public boolean matchesContent(T content) {
                for (String key : required.keySet()) {
                    Pattern pattern = this.forString((String)required.get(key));
                    String test = content.getMeta().get(key);
                    if (null != test && null != pattern && pattern.matcher(test).matches()) {
                        if (requireAll) continue;
                        return true;
                    }
                    if (!requireAll) continue;
                    return false;
                }
                return requireAll;
            }
        };
    }

    public static <T extends ContentMeta> ResourceSelector<T> composeSelector(final ResourceSelector<T> a, final ResourceSelector<T> b, final boolean and) {
        return new ResourceSelector<T>(){

            @Override
            public boolean matchesContent(T content) {
                boolean a1 = a.matchesContent(content);
                if (a1 && !and || !a1 && and) {
                    return a1;
                }
                return b.matchesContent(content);
            }
        };
    }

    public static <T extends ContentMeta> ResourceSelector<T> allResourceSelector() {
        return new ResourceSelector<T>(){

            @Override
            public boolean matchesContent(T content) {
                return true;
            }
        };
    }

    public static <T extends ContentMeta> ResourceSelector<T> resourceSelector(String selector) {
        if (null == selector) {
            throw new NullPointerException();
        }
        if ("*".equals(selector)) {
            return PathUtil.allResourceSelector();
        }
        String[] split = selector.split(";");
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> regexes = new HashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            String s = split[i].trim();
            String[] split1 = s.split("=", 2);
            if (split1.length != 2) continue;
            String key = split1[0].trim();
            String value = split1[1];
            if (value.startsWith("~")) {
                regexes.put(key, value.substring(1).trim());
                continue;
            }
            values.put(key, value.trim());
        }
        ResourceSelector<T> equalsSelector = null;
        ResourceSelector<T> regexSelector = null;
        if (values.size() > 0) {
            equalsSelector = PathUtil.exactMetadataResourceSelector(values, true);
        }
        if (regexes.size() > 0) {
            regexSelector = PathUtil.regexMetadataResourceSelector(regexes, true);
        }
        if (null == equalsSelector) {
            return regexSelector;
        }
        if (null == regexSelector) {
            return equalsSelector;
        }
        return PathUtil.composeSelector(equalsSelector, regexSelector, true);
    }

    public static class PathImpl
    implements Path {
        String pathString;
        private String name;

        public PathImpl(String pathString) {
            this.pathString = pathString;
            this.name = PathUtil.pathName(pathString);
        }

        @Override
        public String getPath() {
            return this.pathString;
        }

        public String toString() {
            return this.pathString;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathImpl)) {
                return false;
            }
            PathImpl path = (PathImpl)o;
            return this.pathString.equals(path.pathString);
        }

        public int hashCode() {
            return this.pathString.hashCode();
        }
    }
}

