/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.conf;

import java.util.ArrayList;
import java.util.List;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathSelector;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.ResourceSelector;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.ContentConverter;
import org.rundeck.storage.conf.ConverterTree;
import org.rundeck.storage.conf.Listener;
import org.rundeck.storage.conf.ListenerTree;
import org.rundeck.storage.conf.PrefixPathTree;
import org.rundeck.storage.conf.SelectiveTree;
import org.rundeck.storage.conf.SubPathTree;
import org.rundeck.storage.conf.TreeStack;
import org.rundeck.storage.impl.EmptyTree;

public class TreeBuilder<T extends ContentMeta> {
    Tree<T> base;
    List<SelectiveTree<T>> treeStack = new ArrayList<SelectiveTree<T>>();

    private TreeBuilder() {
    }

    public static <T extends ContentMeta> TreeBuilder<T> builder() {
        return new TreeBuilder<T>().base((Tree<T>)new EmptyTree());
    }

    public static <T extends ContentMeta> TreeBuilder<T> builder(Tree<T> base) {
        return new TreeBuilder<T>().base(base);
    }

    public static <T extends ContentMeta> Tree<T> subPathTree(Tree<T> base, Path subpath) {
        return new PrefixPathTree<T>(base, subpath);
    }

    public TreeBuilder<T> base(Tree<T> base) {
        this.base = base;
        return this;
    }

    public TreeBuilder<T> subTree(Path path, Tree<T> subtree, boolean fullPath) {
        this.treeStack.add(new SubPathTree<T>(subtree, path, fullPath));
        return this;
    }

    public TreeBuilder<T> convert(ContentConverter<T> converter, Path path) {
        return this.convert(converter, PathUtil.subpathSelector((Path)path));
    }

    public TreeBuilder<T> convert(ContentConverter<T> converter, PathSelector selector) {
        return TreeBuilder.builder(new ConverterTree<T>(this.build(), converter, selector));
    }

    public TreeBuilder<T> convert(ContentConverter<T> converter, ResourceSelector<T> selector) {
        return TreeBuilder.builder(new ConverterTree<T>(this.build(), converter, selector));
    }

    public TreeBuilder<T> convert(ContentConverter<T> converter, Path subpath, ResourceSelector<T> resourceSelector) {
        return this.convert(converter, PathUtil.subpathSelector((Path)subpath), resourceSelector);
    }

    public TreeBuilder<T> convert(ContentConverter<T> converter, PathSelector pathSelector, ResourceSelector<T> resourceSelector) {
        return TreeBuilder.builder(new ConverterTree<T>(this.build(), converter, pathSelector, resourceSelector));
    }

    public TreeBuilder<T> convert(ContentConverter<T> converter) {
        return TreeBuilder.builder(new ConverterTree<T>(this.build(), converter, PathUtil.allpathSelector()));
    }

    public TreeBuilder<T> listen(Listener<T> listener) {
        return this.listen(listener, PathUtil.allpathSelector());
    }

    public TreeBuilder<T> listen(Listener<T> listener, PathSelector pathSelector) {
        return TreeBuilder.builder(new ListenerTree<T>(this.build(), listener, pathSelector));
    }

    public TreeBuilder<T> listen(Listener<T> listener, Path subpath) {
        return TreeBuilder.builder(new ListenerTree<T>(this.build(), listener, PathUtil.subpathSelector((Path)subpath)));
    }

    private TreeBuilder<T> listen(Listener<T> listener, ResourceSelector<T> resourceSelector) {
        return TreeBuilder.builder(new ListenerTree<T>(this.build(), listener, resourceSelector));
    }

    private TreeBuilder<T> listen(Listener<T> listener, String resourceSelector) {
        return TreeBuilder.builder(new ListenerTree<T>(this.build(), listener, PathUtil.resourceSelector((String)resourceSelector)));
    }

    private TreeBuilder<T> listen(Listener<T> listener, PathSelector pathSelector, ResourceSelector<T> resourceSelector) {
        return TreeBuilder.builder(new ListenerTree<T>(this.build(), listener, pathSelector, resourceSelector));
    }

    public Tree<T> build() {
        Object result = this.base;
        if (null == this.base && this.treeStack.size() == 1) {
            result = this.treeStack.get(0);
        } else if (this.treeStack.size() > 0) {
            result = new TreeStack<T>(this.treeStack, this.base);
        } else if (null == this.base) {
            throw new IllegalArgumentException("base tree was not set");
        }
        return result;
    }
}

