/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.exception;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.exception.CompileException;
import org.rythmengine.exception.FastRuntimeException;
import org.rythmengine.exception.ParseException;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.utils.F;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class RythmException
extends FastRuntimeException {
    public int javaLineNumber = 0;
    public int templateLineNumber = -1;
    public String errorMessage = "";
    public String originalMessage = "";
    private transient TemplateClass templateClass = null;
    public String javaSource;
    public String templateSource;
    public String templateName;
    public String templateSourceInfo;
    public String javaSourceInfo;
    private static final Pattern P = Pattern.compile(".*\\/\\/line:\\s*([0-9]+).*");

    public RythmException(RythmEngine engine, Throwable t, String templateName, String javaSource, String templateSource, int javaLineNumber, int templateLineNumber, String message) {
        super(message, t);
        boolean logJava = (Boolean)engine.conf().get(RythmConfigurationKey.LOG_SOURCE_JAVA_ENABLED);
        boolean logTmpl = (Boolean)engine.conf().get(RythmConfigurationKey.LOG_SOURCE_TEMPLATE_ENABLED);
        F.T4<String, Integer, String, String> t4 = RythmException.parse(message, logJava || this instanceof CompileException, logTmpl || this instanceof ParseException, javaLineNumber, templateLineNumber, javaSource, templateSource, null);
        this.templateName = templateName;
        this.javaSource = javaSource;
        this.templateSource = templateSource;
        this.javaLineNumber = javaLineNumber;
        this.templateLineNumber = (Integer)t4._2;
        this.originalMessage = message;
        this.errorMessage = (String)t4._1;
        this.templateSourceInfo = (String)t4._3;
        this.javaSourceInfo = (String)t4._4;
    }

    public RythmException(RythmEngine engine, String templateName, String javaSource, String templateSource, int javaLineNumber, int templateLineNumber, String message) {
        this(engine, null, templateName, javaSource, templateSource, javaLineNumber, templateLineNumber, message);
    }

    public RythmException(RythmEngine engine, String templateName, String javaSource, String templateSource, int javaLineNumber, String message) {
        this(engine, null, templateName, javaSource, templateSource, javaLineNumber, -1, message);
    }

    public RythmException(RythmEngine engine, Throwable t, TemplateClass tc, int javaLineNumber, int templateLineNumber, String message) {
        super(message, t);
        boolean logJava = (Boolean)engine.conf().get(RythmConfigurationKey.LOG_SOURCE_JAVA_ENABLED);
        boolean logTmpl = (Boolean)engine.conf().get(RythmConfigurationKey.LOG_SOURCE_TEMPLATE_ENABLED);
        F.T4<String, Integer, String, String> t4 = RythmException.parse(message, logJava, logTmpl, javaLineNumber, templateLineNumber, tc.javaSource, tc.getTemplateSource(), tc);
        this.javaLineNumber = javaLineNumber;
        this.templateClass = tc;
        this.javaSource = tc.javaSource;
        this.templateSource = tc.getTemplateSource();
        this.templateLineNumber = (Integer)t4._2;
        this.originalMessage = message;
        this.errorMessage = (String)t4._1;
        this.templateSourceInfo = (String)t4._3;
        this.javaSourceInfo = (String)t4._4;
    }

    public String errorTitle() {
        return "RythmException";
    }

    public String errorDesc() {
        return String.format("Generic Rythm Exception: <strong>%s</strong>", this.originalMessage.replace("<", "&lt;"));
    }

    public String javaSourceInfo() {
        if (null != this.javaSourceInfo) {
            return this.javaSourceInfo;
        }
        String javaSource = this.getJavaSource();
        if (S.isEmpty(javaSource)) {
            return "No java source available";
        }
        TextBuilder tb = new TextBuilder();
        tb.p("Relevant Java source lines:\n-------------------------------------------------\n");
        String[] lines = javaSource.split("(\\n\\r|\\r\\n|\\r|\\n)");
        int start = 0;
        int end = lines.length;
        int javaLineNumber = this.javaLineNumber;
        if (javaLineNumber > -1 && javaLineNumber < lines.length) {
            start = Math.max(0, javaLineNumber - 6);
            end = Math.min(end, javaLineNumber + 6);
        }
        for (int line = start; line < end; ++line) {
            if (line + 1 == javaLineNumber) {
                tb.p(">> ");
            } else {
                tb.p("   ");
            }
            tb.p(line + 1).p(": ").p(lines[line]).p("\n");
        }
        this.javaSourceInfo = tb.toString();
        return this.javaSourceInfo;
    }

    public String templateSourceInfo() {
        if (null != this.templateSourceInfo) {
            return this.templateSourceInfo;
        }
        String tmplSource = this.getTemplateSource();
        if (S.isEmpty(tmplSource)) {
            return "No template source available";
        }
        TextBuilder tb = new TextBuilder();
        tb.p("Relevant template source lines:\n-------------------------------------------------\n");
        String[] lines = tmplSource.split("(\\n\\r|\\r\\n|\\r|\\n)");
        int start = 0;
        int end = lines.length;
        if (this.templateLineNumber > -1 && this.templateLineNumber < lines.length) {
            start = Math.max(0, this.templateLineNumber - 6);
            end = Math.min(end, this.templateLineNumber + 6);
        }
        for (int line = start; line < end; ++line) {
            if (line + 1 == this.templateLineNumber) {
                tb.p(">> ");
            } else {
                tb.p("   ");
            }
            tb.p(line + 1).p(": ").p(lines[line]).p("\n");
        }
        this.templateSourceInfo = tb.toString();
        return this.templateSourceInfo;
    }

    public RythmException(RythmEngine engine, TemplateClass tc, int javaLineNumber, int templateLineNumber, String message) {
        this(engine, null, tc, javaLineNumber, templateLineNumber, message);
    }

    public RythmException(RythmEngine engine, TemplateClass tc, int javaLineNumber, String message) {
        this(engine, null, tc, javaLineNumber, -1, message);
    }

    private static int resolveTemplateLineNumber(int javaLineNumber, int templateLineNumber, String javaSource, TemplateClass templateClass) {
        String errorLine;
        Matcher m;
        String[] lines;
        if (javaLineNumber != -1 && templateLineNumber == -1 && javaLineNumber < (lines = RythmException.getJavaSource(javaSource, templateClass).split("(\\r\\n|\\n\\r|\\n|\\r)")).length && (m = P.matcher(errorLine = lines[javaLineNumber - 1])).matches()) {
            return Integer.parseInt(m.group(1));
        }
        return templateLineNumber;
    }

    private static F.T4<String, Integer, String, String> parse(String message, boolean logJava, boolean logTmpl, int javaLineNumber, int templateLineNumber, String javaSource, String templateSource, TemplateClass templateClass) {
        int line;
        int end;
        int start;
        String[] lines;
        javaSource = RythmException.getJavaSource(javaSource, templateClass);
        String tmplSource = RythmException.getTemplateSource(templateSource, templateClass);
        String tmplSourceInfo = null;
        String javaSourceInfo = null;
        templateLineNumber = RythmException.resolveTemplateLineNumber(javaLineNumber, templateLineNumber, javaSource, templateClass);
        if (!logJava && !logTmpl) {
            return new F.T4<String, Integer, Object, Object>(message, templateLineNumber, tmplSourceInfo, javaSourceInfo);
        }
        TextBuilder tb = new TextBuilder();
        tb.pn(message);
        tb.p("\nTemplate: ").p(templateClass.getKey()).p("\n");
        if (logTmpl && !S.isEmpty(tmplSource)) {
            TextBuilder tbTmpl = new TextBuilder();
            tbTmpl.p("\nRelevant template source lines:\n-------------------------------------------------\n");
            lines = tmplSource.split("(\\n\\r|\\r\\n|\\r|\\n)");
            start = 0;
            end = lines.length;
            if (templateLineNumber > -1) {
                start = Math.max(0, templateLineNumber - 6);
                end = Math.min(end, templateLineNumber + 6);
            }
            for (line = start; line < end; ++line) {
                if (line + 1 == templateLineNumber) {
                    tbTmpl.p(">> ");
                } else {
                    tbTmpl.p("   ");
                }
                tbTmpl.p(line + 1).p(": ").p(lines[line]).p("\n");
            }
            tmplSourceInfo = tbTmpl.toString();
        }
        if ((logJava || templateLineNumber < 0) && !S.isEmpty(javaSource)) {
            TextBuilder tbJava = new TextBuilder();
            tbJava.p("\nRelevant Java source lines:\n-------------------------------------------------\n");
            lines = javaSource.split("(\\n\\r|\\r\\n|\\r|\\n)");
            start = 0;
            end = lines.length;
            if (javaLineNumber > -1) {
                start = Math.max(0, javaLineNumber - 6);
                end = Math.min(end, javaLineNumber + 6);
            }
            for (line = start; line < end; ++line) {
                if (line + 1 == javaLineNumber) {
                    tbJava.p(">> ");
                } else {
                    tbJava.p("   ");
                }
                tbJava.p(line + 1).p(": ").p(lines[line]).p("\n");
            }
            javaSourceInfo = tbJava.toString();
        }
        tb.pn(tmplSourceInfo);
        tb.pn(javaSourceInfo);
        return new F.T4<String, Integer, Object, Object>(tb.toString(), templateLineNumber, tmplSourceInfo, javaSourceInfo);
    }

    private static String getJavaSource(String javaSource, TemplateClass templateClass) {
        if (null != javaSource) {
            return javaSource;
        }
        return null == templateClass.javaSource ? "" : templateClass.javaSource;
    }

    public String getJavaSource() {
        if (null != this.javaSource) {
            return this.javaSource;
        }
        return null == this.templateClass.javaSource ? "" : this.templateClass.javaSource;
    }

    private static String getTemplateSource(String templateSource, TemplateClass templateClass) {
        if (null != templateSource) {
            return templateSource;
        }
        return templateClass.templateResource.asTemplateContent();
    }

    public String getTemplateSource() {
        if (null != this.templateSource) {
            return this.templateSource;
        }
        return this.templateClass.templateResource.asTemplateContent();
    }

    public String getTemplateName() {
        if (null != this.templateName) {
            return this.templateName;
        }
        return this.templateClass.getKey().toString();
    }

    public void clearDetailErrorMessage() {
        this.errorMessage = super.getMessage();
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String getSimpleMessage() {
        return super.getMessage();
    }
}

