/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;

public class CodeTypeBlockStartSensor
extends ParserBase {
    private static Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public CodeTypeBlockStartSensor(IContext context) {
        super(context);
    }

    @Override
    public Token go() {
        IContext ctx = this.ctx();
        ICodeType curType = ctx.peekCodeType();
        if (!curType.allowInternalTypeBlock()) {
            return null;
        }
        String remain = ctx.getRemain();
        Iterable<ICodeType> types = ctx.getEngine().extensionManager().templateLangs();
        for (ICodeType type : types) {
            Matcher m;
            if (!type.allowedExternalTypes().contains(curType)) continue;
            String blockStart = type.blockStart();
            if (null == blockStart) {
                logger.warn("null block start found for lang[%s] inside lang[%s]", type, curType);
                continue;
            }
            Pattern pStart = patterns.get(blockStart);
            if (null == pStart) {
                pStart = Pattern.compile(blockStart, 32);
                patterns.put(blockStart, pStart);
            }
            if (!(m = pStart.matcher(remain)).matches()) continue;
            ctx.pushCodeType(type);
            String matched = m.group(1);
            ctx.step(matched.length());
            String s = matched;
            if (matched.indexOf(64) > -1) {
                char ch = s.charAt(0);
                s = s.substring(1);
                String code = ctx.getCodeBuilder().addInlineInclude(s, ctx.currentLine());
                if (matched.endsWith("\n")) {
                    code = code + ";p(\"\\n\");";
                }
                s = String.format("p('%s');", String.valueOf(ch)) + code + String.format(";__ctx.pushCodeType(%s);", type.newInstanceStr());
            } else {
                s = s.replaceAll("(\\r?\\n)+", "\\\\n").replaceAll("\"", "\\\\\"");
                s = String.format("p(\"%s\");__ctx.pushCodeType(%s);", s, type.newInstanceStr());
            }
            return new CodeToken(s, ctx);
        }
        return null;
    }

    public static void main(String[] args) {
        String s = "(<\\s*script[^<>]*?>).*";
        Pattern p = Pattern.compile(s);
        s = "<script src='@src'></script><script src='@src'></script>";
        Matcher m = p.matcher(s);
        System.out.println(m.matches());
        System.out.println(m.group());
        System.out.println(m.group(1));
    }
}

