/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.RemoveLeadingSpacesIfLineBreakParser;
import org.rythmengine.internal.parser.build_in.ExpressionParser;
import org.rythmengine.internal.parser.build_in.ForEachCodeToken;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class ForEachParser
extends KeywordParserFactory {
    @Override
    public IParser create(final IContext ctx) {
        return new RemoveLeadingSpacesIfLineBreakParser(ctx){

            @Override
            public Token go() {
                String blank;
                Regex r0;
                boolean leadingLB;
                String remain;
                Regex r = new Regex(String.format(ForEachParser.this.patternStr2(), this.dialect().a(), ForEachParser.this.keyword()));
                if (!r.search(remain = this.remain())) {
                    this.raiseParseException("Error parsing @for statement, correct usage: @for(Type var: Iterable){...} or @for(int i = ...)", new Object[0]);
                }
                int lineNo = ctx.currentLine();
                String matched = r.stringMatched();
                boolean bl = leadingLB = !this.isLastBuilderLiteral();
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    if (matched.startsWith("\n")) {
                        leadingLB = true;
                        ++lineNo;
                    }
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    if (!matched.startsWith("\n") && (r0 = new Regex("\\n([ \\t\\x0B\\f]*).*")).search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String s = r.stringMatched(2);
                String sep = r.stringMatched(4);
                if (!S.empty(sep)) {
                    sep = sep.replaceAll("(\\r?\\n)+", "\\\\n");
                    boolean hasQuotation = (sep = S.stripBrace(sep).trim()).startsWith("'");
                    if (hasQuotation) {
                        sep = S.strip(sep, "'", "'");
                        sep = "\"" + sep + "\"";
                    }
                    sep = "".equals(sep) ? "\",\"" : ExpressionParser.processPositionPlaceHolder(sep);
                }
                String separator = sep;
                if (s.contains(";")) {
                    if (!this.ctx().getDialect().enableFreeForLoop()) {
                        throw new TemplateParser.NoFreeLoopException(this.ctx());
                    }
                    String s1 = "for ";
                    String s2 = "{ //line: " + lineNo + "\n\t";
                    if (null != sep) {
                        String varCursor = ctx.getCodeBuilder().newVarName();
                        s1 = "int " + varCursor + " = 0;//line: " + lineNo + "\nfor ";
                        s2 = s2 + "if (" + varCursor + "++ > 0) {p(" + separator + ");} //line: " + lineNo + "\n\t";
                    }
                    this.processFollowingOpenBraceAndLineBreak(leadingLB);
                    return new BlockCodeToken(s1 + s + s2, this.ctx()){

                        @Override
                        public void openBlock() {
                            this.ctx().pushBreak(IContext.Break.BREAK);
                            this.ctx().pushContinue(IContext.Continue.CONTINUE);
                        }

                        @Override
                        public void output() {
                            super.output();
                        }

                        @Override
                        public String closeBlock() {
                            this.ctx().popBreak();
                            return super.closeBlock();
                        }
                    };
                }
                s = S.stripBrace(s);
                int pos0 = -1;
                int pos1 = -1;
                String iterable = null;
                String varname = null;
                String type = null;
                if (s.matches("\\s*\".*")) {
                    iterable = s;
                } else if (s.contains(" in ")) {
                    pos0 = s.indexOf(" in ");
                    pos1 = pos0 + 4;
                } else if (s.contains(" <- ")) {
                    pos0 = s.indexOf(" <- ");
                    pos1 = pos0 + 4;
                } else if (s.contains(":")) {
                    pos0 = s.indexOf(":");
                    pos1 = pos0 + 1;
                } else {
                    iterable = s;
                }
                if (-1 != pos0) {
                    String s1 = s.substring(0, pos0).trim();
                    iterable = s.substring(pos1, s.length());
                    if (s1.contains(" ")) {
                        pos0 = s1.lastIndexOf(" ");
                        type = s1.substring(0, pos0);
                        varname = s1.substring(pos0, s1.length());
                    } else {
                        varname = s1;
                    }
                }
                this.processFollowingOpenBraceAndLineBreak(leadingLB);
                return new ForEachCodeToken(type, varname, iterable, this.ctx(), lineNo, separator);
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.EACH;
    }

    protected String patternStr2() {
        return "^\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))(\\.join((?@())))?([ \\t\\x0B\\f]*\\n?)";
    }

    @Override
    protected String patternStr() {
        return null;
    }
}

