/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.rythmengine.RythmEngine;
import org.rythmengine.Sandbox;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.RythmThreadFactory;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ClasspathResourceLoader;
import org.rythmengine.resource.ClasspathTemplateResource;
import org.rythmengine.resource.FileResourceLoader;
import org.rythmengine.resource.FileTemplateResource;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.utils.S;

public class TemplateResourceManager {
    private static final ILogger logger = Logger.get(TemplateResourceManager.class);
    public static final ITemplateResource NULL = new ITemplateResource(){
        private Throwable error;

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public String getSuggestedClassName() {
            return null;
        }

        @Override
        public String asTemplateContent() {
            return null;
        }

        @Override
        public boolean refresh() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public ICodeType codeType(RythmEngine engine) {
            return null;
        }

        @Override
        public ITemplateResourceLoader getLoader() {
            return null;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public void setError(Throwable error) {
            this.error = error;
        }
    };
    private RythmEngine engine;
    private Map<Object, ITemplateResource> cache = new HashMap<Object, ITemplateResource>();
    private List<ITemplateResourceLoader> loaders;
    private FileResourceLoader adhocFileLoader = null;
    private Map<Object, ITemplateResourceLoader> whichLoader = new HashMap<Object, ITemplateResourceLoader>();
    private boolean typeInference;
    private static Set<String> blackList = new HashSet<String>();
    private static ThreadLocal<Stack<Set<String>>> tmpBlackList = new ThreadLocal<Stack<Set<String>>>(){

        @Override
        protected Stack<Set<String>> initialValue() {
            return new Stack<Set<String>>();
        }
    };
    private ScheduledExecutorService loadingService = new ScheduledThreadPoolExecutor(1, new ScannerThreadFactory());

    public static void setUpTmpBlackList() {
        tmpBlackList.get().push(new HashSet());
    }

    public static void reportNonResource(String str) {
        Stack<Set<String>> ss = tmpBlackList.get();
        if (ss.isEmpty()) {
            tmpBlackList.remove();
            blackList.add(str);
        } else {
            ss.peek().add(str);
        }
    }

    public static void commitTmpBlackList() {
        Stack<Set<String>> sss = tmpBlackList.get();
        if (!sss.isEmpty()) {
            Set<String> ss = sss.pop();
            blackList.addAll(ss);
        }
        if (sss.isEmpty()) {
            tmpBlackList.remove();
        }
    }

    public static void rollbackTmpBlackList() {
        Stack<Set<String>> sss = tmpBlackList.get();
        if (!sss.isEmpty()) {
            sss.pop();
        }
        if (sss.isEmpty()) {
            tmpBlackList.remove();
        }
    }

    public static void cleanUpTmplBlackList() {
        tmpBlackList.remove();
    }

    public TemplateResourceManager(RythmEngine engine) {
        this.engine = engine;
        RythmConfiguration conf = engine.conf();
        this.typeInference = conf.typeInferenceEnabled();
        this.loaders = new ArrayList<ITemplateResourceLoader>(conf.getList(RythmConfigurationKey.RESOURCE_LOADER_IMPLS, ITemplateResourceLoader.class));
        if (!this.loaders.isEmpty()) {
            for (ITemplateResourceLoader loader : this.loaders) {
                loader.setEngine(this.engine);
            }
            Boolean defLoader = (Boolean)conf.get(RythmConfigurationKey.RESOURCE_DEF_LOADER_ENABLED);
            if (!defLoader.booleanValue()) {
                return;
            }
        }
        List<URI> roots = conf.templateHome();
        for (URI root : roots) {
            if (null == root) continue;
            String scheme = root.getScheme();
            if (S.eq(scheme, "jar")) {
                String s = root.getSchemeSpecificPart();
                int pos = s.indexOf(".jar!");
                String home = s.substring(pos + 5);
                ClasspathResourceLoader crl = new ClasspathResourceLoader(engine, home);
                this.loaders.add(crl);
                continue;
            }
            if (!S.eq(scheme, "file")) continue;
            FileResourceLoader frl = new FileResourceLoader(engine, new File(root.getPath()));
            if (null == this.adhocFileLoader) {
                this.adhocFileLoader = frl;
            }
            this.loaders.add(frl);
        }
    }

    public void addResourceLoader(ITemplateResourceLoader loader) {
        if (!this.loaders.contains(loader)) {
            this.loaders.add(loader);
        }
    }

    public void prependResourceLoader(ITemplateResourceLoader loader) {
        if (!this.loaders.contains(loader)) {
            this.loaders.add(0, loader);
        }
    }

    private ITemplateResource cache(ITemplateResource resource) {
        return this.cache(null, resource);
    }

    private ITemplateResource cache(Object key, ITemplateResource resource) {
        if (resource.isValid()) {
            this.cache.put(resource.getKey(), resource);
            if (null != key) {
                this.cache.put(key, resource);
            }
        }
        return resource;
    }

    public TemplateClass tryLoadTemplate(String tmplName, TemplateClass callerClass, ICodeType codeType) {
        ITemplateResourceLoader loader;
        ITemplateResourceLoader loader2;
        if (blackList.contains(tmplName)) {
            return null;
        }
        TemplateClass tc = null;
        RythmEngine engine = this.engine;
        if (null != callerClass && null != (loader2 = this.whichLoader(callerClass.templateResource))) {
            return loader2.tryLoadTemplate(tmplName, engine, callerClass, codeType);
        }
        Iterator<ITemplateResourceLoader> iterator = this.loaders.iterator();
        while (iterator.hasNext() && null == (tc = (loader = iterator.next()).tryLoadTemplate(tmplName, engine, callerClass, codeType))) {
        }
        return tc;
    }

    public ITemplateResource get(File file) {
        return this.cache(new FileTemplateResource(file, this.adhocFileLoader));
    }

    public ITemplateResource get(String str) {
        ITemplateResource resource = this.getResource(str);
        if (!resource.isValid()) {
            resource = new StringTemplateResource(str);
        }
        return this.cache(resource);
    }

    public ITemplateResourceLoader whichLoader(ITemplateResource resource) {
        return this.whichLoader.get(resource.getKey());
    }

    public ITemplateResource getResource(String key) {
        ITemplateResource resource = this.cache.get(key);
        if (null != resource) {
            return resource;
        }
        if (Sandbox.isRestricted()) {
            return NULL;
        }
        for (ITemplateResourceLoader loader : this.loaders) {
            resource = loader.load(key);
            if (null == resource || !resource.isValid()) continue;
            this.whichLoader.put(resource.getKey(), loader);
            this.whichLoader.put(key, loader);
            if (key == resource.getKey() || !(resource instanceof ClasspathTemplateResource)) break;
            ((ClasspathTemplateResource)resource).setKey2(key);
            break;
        }
        return null == resource ? NULL : this.cache(key, resource);
    }

    public void scan() {
        for (ITemplateResourceLoader loader : this.loaders) {
            loader.scan(this);
        }
    }

    public void resourceLoaded(ITemplateResource resource) {
        this.resourceLoaded(resource, true);
    }

    public TemplateClass resourceLoaded(ITemplateResource resource, boolean async) {
        ITemplateResourceLoader loader = resource.getLoader();
        this.whichLoader.put(resource.getKey(), loader);
        return this._resourceLoaded(resource);
    }

    private TemplateClass _resourceLoaded(ITemplateResource resource) {
        RythmEngine engine;
        TemplateClass tc;
        if (!resource.isValid()) {
            return null;
        }
        String key = S.str(resource.getKey());
        if (this.typeInference) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = (engine = this.engine).classes().getByTemplate(key))) {
            tc = new TemplateClass(resource, engine);
        }
        tc.asTemplate(engine);
        return tc;
    }

    public void shutdown() {
        this.loadingService.shutdown();
    }

    private static class ScannerThreadFactory
    extends RythmThreadFactory {
        private ScannerThreadFactory() {
            super("rythm-scanner");
        }
    }
}

