/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.auth;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.rzo.netty.ahessian.auth.AuthToken;

@ChannelPipelineCoverage(value="one")
public class ServerAuthFilter
extends SimpleChannelUpstreamHandler {
    private AuthToken _token = null;
    private boolean _authenticated = false;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerAuthFilter.class);

    public ServerAuthFilter(AuthToken token) {
        this.setToken(token);
    }

    public void setToken(AuthToken token) {
        this._token = token;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this._authenticated) {
            int result = this._token.authenticate(ctx, e);
            if (result == 2) {
                logger.warn("authentication failed -> close connection");
                ctx.getChannel().close();
            } else if (result == 1) {
                this._authenticated = true;
            }
        } else {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._token.disconnected();
        ctx.sendUpstream((ChannelEvent)e);
    }
}

