/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.crypto;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.rzo.netty.ahessian.crypto.CryptoConstants;
import org.rzo.netty.ahessian.crypto.ServerCryptoFilter;
import org.rzo.netty.ahessian.crypto.StreamCipher;
import org.rzo.netty.ahessian.crypto.StreamCipherFactory;
import org.rzo.netty.ahessian.crypto.Util;
import org.rzo.netty.ahessian.log.OutLogger;

public class ClientCryptoFilter
extends SimpleChannelHandler
implements CryptoConstants {
    private StreamCipher _encodeCipher;
    private StreamCipher _decodeCipher;
    private byte[] _encodedPublicKey;
    private int _bytesRead;
    private SecureRandom _secureRandom = new SecureRandom();
    private ChannelEvent _connectedEvent;
    private byte[] _password = new byte[15];

    public ClientCryptoFilter() {
        Arrays.fill(this._password, (byte)0);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this._decodeCipher != null) {
            MessageEvent m = Util.code(this._decodeCipher, e, true);
            ctx.sendUpstream((ChannelEvent)m);
        } else {
            ChannelBuffer b = (ChannelBuffer)e.getMessage();
            if (this._encodedPublicKey == null) {
                int size = b.readInt();
                this._encodedPublicKey = new byte[size];
            }
            int available = b.readableBytes();
            int toRead = Math.min(this._encodedPublicKey.length - this._bytesRead, available);
            b.readBytes(this._encodedPublicKey, this._bytesRead, toRead);
            this._bytesRead += toRead;
            if (this._bytesRead == this._encodedPublicKey.length) {
                this.sendSecretKey(ctx);
            }
        }
    }

    private Cipher getAsymCipher() {
        try {
            KeyFactory fact = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec ks = new X509EncodedKeySpec(this._encodedPublicKey);
            PublicKey pubKey = fact.generatePublic(ks);
            String type = "".equals("ECB/NOPADDING") ? "RSA" : "RSA/ECB/NOPADDING";
            Cipher result = Cipher.getInstance(type);
            result.init(1, pubKey);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] getSymKey() {
        try {
            byte[] key = new byte[16];
            this._secureRandom.nextBytes(key);
            return key;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private byte[] getIv() {
        byte[] iv = new byte[8];
        this._secureRandom.nextBytes(iv);
        return iv;
    }

    private void sendSecretKey(ChannelHandlerContext ctx) {
        try {
            byte[] symKeyEncoded = this.getSymKey();
            byte[] ivEncoded = this.getIv();
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            b.write(ivEncoded);
            b.write(symKeyEncoded);
            if (this._password != null) {
                b.write(this._password);
            }
            b.flush();
            System.out.println("generated iv+key: " + OutLogger.asString(b.toByteArray()));
            Cipher asymCipher = this.getAsymCipher();
            byte[] encryptedIvSymKey = asymCipher.doFinal(b.toByteArray());
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            cb.writeInt(encryptedIvSymKey.length);
            cb.writeBytes(encryptedIvSymKey);
            Channel channel = ctx.getChannel();
            ChannelFuture future = Channels.future((Channel)ctx.getChannel());
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)cb);
            future.await();
            this._encodeCipher = StreamCipherFactory.createCipher("RC4");
            this._encodeCipher.engineInitEncrypt(symKeyEncoded, ivEncoded);
            this._decodeCipher = StreamCipherFactory.createCipher("RC4");
            this._decodeCipher.engineInitDecrypt(symKeyEncoded, ivEncoded);
            ctx.sendUpstream(this._connectedEvent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._connectedEvent = e;
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this._encodeCipher != null) {
            MessageEvent m = Util.code(this._encodeCipher, e, false);
            ctx.sendDownstream((ChannelEvent)m);
        }
    }

    public void setPassword(byte[] password) {
        if (password == null || password.length == 0) {
            return;
        }
        int length = Math.min(15, password.length);
        System.arraycopy(password, 0, this._password, 0, length);
    }

    public static void main(String[] args) {
        ServerCryptoFilter s = new ServerCryptoFilter();
        ClientCryptoFilter c = new ClientCryptoFilter();
        c._encodedPublicKey = s.getPublicKeyEncoded();
        c.sendSecretKey(null);
    }
}

