/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.utils.MyReentrantLock;

public class PushInputStreamConsumer
extends SimpleChannelUpstreamHandler {
    volatile Lock _lock = new MyReentrantLock();
    AtomicInteger _consumerThreadsCount = new AtomicInteger(0);
    volatile InputStreamConsumer _consumer;
    volatile Executor _executor;

    public PushInputStreamConsumer(InputStreamConsumer consumer, Executor executor) {
        this._consumer = consumer;
        this._executor = executor;
    }

    public void messageReceived(final ChannelHandlerContext ctx, final MessageEvent evt) throws Exception {
        this._executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String tName = Thread.currentThread().getName();
                try {
                    PushInputStreamConsumer.this.run(ctx, evt);
                }
                finally {
                    Thread.currentThread().setName(tName);
                    PushInputStreamConsumer.this._consumerThreadsCount.decrementAndGet();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ChannelHandlerContext ctx, MessageEvent evt) {
        if (this._consumer.isBufferEmpty()) {
            return;
        }
        if (this._consumerThreadsCount.incrementAndGet() > 2) {
            this._consumerThreadsCount.decrementAndGet();
            return;
        }
        Thread.currentThread().setName("ahessian-PushInputStreamConsumer-#" + this._consumerThreadsCount.get());
        this._lock.lock();
        try {
            this._consumer.consume(ctx, (InputStream)evt.getMessage());
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
        finally {
            this._consumerThreadsCount.decrementAndGet();
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._lock.lock();
        try {
            this._consumer.setContext(ctx);
        }
        finally {
            this._lock.unlock();
        }
        ctx.sendUpstream((ChannelEvent)e);
    }
}

